#include "mbed.h"

class RC_PWM {
    public:
        
        /** Create a new PWM Output for RC Components
         *
         * @param _PWM is the pin for PWM Output 
         * @param PWM_min minimum high time in µs
         * @param PWM_max maximum high time in µs
         * @param frequenz repeating Frequenz in Hz
         */
        RC_PWM(PinName _PWM, int PWM_min, int PWM_max, int frequenz);

        /** Create a new PWM Output for RC Components
         *
         * @param _PWM is the pin for PWM Output 
         */
        RC_PWM(PinName _PWM);

        PwmOut pwm;
        
        /** sets PWM in Prozentage
         * 
         * @param prozent of PWM range 0 - 100
         *
         */
        void set(char prozent);
        
        /** sets PWM in µs
         * 
         * @param us set PWM hightime in µs
         *
         */
        void set_us(int us);
        
        
        int min;
        
        int max;
        
        int frq;
        
    private:
    
       /** limit PWM between PWM_min and PWM_max
         * 
         * @param us_i µs input limited µs on output
         *
         */
        int limit(int us_i);
        
};        