#include "rc_pwm.h"

       /** Create a new PWM Output for RC Components
         *
         * @param _PWM is the pin for PWM Output 
         * @param PWM_min minimum high time in µs
         * @param PWM_max maximum high time in µs
         * @param frequenz repeating Frequenz in Hz
         */
       RC_PWM::RC_PWM(PinName _PWM, int PWM_min, int PWM_max, int frequenz): pwm(_PWM), min(PWM_min),max(PWM_max),frq(frequenz){
         pwm.period(1/frq);
         pwm.pulsewidth_us(min); 
        };
        
       /** Create a new PWM Output for RC Components
         *
         * @param _PWM is the pin for PWM Output 
         */
       RC_PWM::RC_PWM(PinName _PWM): pwm(_PWM), min(900),max(1900),frq(50){
         pwm.period(1/frq);
         pwm.pulsewidth_us(min); 
        };
        
        /** sets PWM in Prozentage
         * 
         * @param prozent of PWM range 0 - 100
         *
         */
        void RC_PWM::set(char prozent){
         float temp;
         temp = ((max-min) * prozent / 100.0) + min;
         ;
         pwm.pulsewidth_us(limit(temp));
        }
        
        /** sets PWM in µs
         * 
         * @param us of PWM range PWM_min - PWM_max
         *
         */
        void RC_PWM::set_us(int us){
          pwm.pulsewidth_us(limit(us));  
        };
        
        
        /** limit PWM between PWM_min and PWM_max
         * 
         * @param us input µs output limited µs
         *
         */
        int RC_PWM::limit(int us_i){
            if (us_i < min) {return min;}
            if (us_i > max) {return max;}
            return us_i;
            };        