#include "stdio.h"

struct struct_system
{
    uint8_t  length              ;//1
    uint8_t  ID                  ;//2
    uint8_t  do_time     : 1     ;//3.0
    uint8_t  do_measure  : 1     ;//3.1
    uint8_t  C_limit     : 1     ;//3.2
    uint8_t  RPM_limit   : 1     ;//3.3
    uint8_t  T_limit     : 1     ;//3.4
    uint8_t  run         : 1     ;//3.5
    uint8_t  flag7       : 1     ;//3.6
    uint8_t  flag8       : 1     ;//3.7
    uint8_t  blade               ;//4
    uint16_t Amax                ;//6    
    uint16_t RPMmax              ;//8
    uint16_t PWMmax              ;//10 @rule: name=Max.PWM; expr=1200+PWMmax*3; unit=us
    uint16_t PWMmin              ;//12 @rule: name=Min.PWM; expr=900+PWMmin*2; unit=us
    uint16_t air_ro              ;//14 @rule: name=Air Density; expr=air_ro/10000; unit=kg/m³
    uint8_t  t_eng_max           ;//15 @rule: name=Max. Eng. Temp; expr=t_max; unit=C    
    uint8_t  fast                ;//16
    uint8_t  slow                ;//17
    uint8_t  measure             ;//18
    uint8_t  pwm                 ;//19
    uint8_t  version             ;//20
    float    open7               ;//24
    uint8_t  ck                  ;//25
} sys = {25,0};

struct struct_value        
{
    uint8_t  length              ;//1
    uint8_t  ID                  ;//2
    uint8_t  flag1               ;//3
    uint8_t  flag2               ;//4
    int16_t  rpm                 ;//6   @rule: name=RPM; expr=rpm; unit=1/min
    float    thrust              ;//10  @rule: name=F_Thrust; expr=thrust; unit=N
    float    torque              ;//14  @rule: name=M_Torque; expr=torque; unit=Nm  
    float    voltage             ;//18  @rule: name=Volt; expr=voltage; unit=V
    float    current             ;//22  @rule: name=Current; expr=current; unit=V
    float    power_in            ;//26  @rule: name=Power_In; expr=power_in; unit=W
    float    power_out           ;//30  @rule: name=Power_Out; expr=power_out; unit=W
    float    eta                 ;//34  @rule: name=effectivity; expr=effectivity; unit=%
    float    thrust_eff          ;//38  @rule: name=Thrust/W; expr=thrust_eff; unit=mN/W
    float    p_prop              ;//42  @rule: name=Pressure; expr=p_prop; unit=Pa
    float    p_tunnel            ;//46  @rule: name=Pressure; expr=p_tunnel; unit=Pa
    float    p_abs               ;//50  @rule: name=Pressure; expr=p_abs; unit=Pa
    float    v_prop              ;//54  @rule: name=Propeller_Windspeed; expr=v_prop; unit=m/s
    float    v_tunnel            ;//58  @rule: name=Tunnel_Windspeed; expr=v_tunne; unit=m/s
    float    temp_eng            ;//62  @rule: name=Temperatur_1; expr=temp_eng; unit=C
    float    temp_air            ;//66  @rule: name=Temperatur_2; expr=temp_air; unit=C
    float    air_ro              ;//70  @rule: name=Air Density; expr=air_ro; unit=kg/m³
    int16_t  pwm_act             ;//74  @rule: name=PWM_Output; expr=pwm_act; unit=C                
    uint8_t  ck                  ;//75
} values ={41, 1};

struct struct_value_raw        
{
    uint8_t  length              ;//1
    uint8_t  ID                  ;//2
    uint8_t  flag1               ;//3
    uint8_t  flag2               ;//4
    int16_t  rpm                 ;//6   @rule: name=RPM; expr=rpm; unit=1/min
    int16_t  thrust              ;//8   @rule: name=F_Thrust; expr=thrust/100; unit=N
    int16_t  torque              ;//10  @rule: name=M_Torque; expr=torque/1000; unit=Nm  
    uint16_t voltage             ;//12  @rule: name=Volt; expr=voltage/1000; unit=V
    uint16_t current             ;//14  @rule: name=Current; expr=current/1000; unit=A
    uint16_t power_in            ;//16  @rule: name=Power_In; expr=power_in/100; unit=W
    uint16_t power_out           ;//18  @rule: name=Power_Out; expr=power_out/100; unit=W
    uint16_t eta                 ;//20  @rule: name=effectivity; expr=effectivity/10; unit=%
    int16_t  thrust_eff          ;//22  @rule: name=Thrust/W; expr=thrust_eff/100; unit=mN/W
    uint16_t  p_prop             ;//24  @rule: name=Pressure; expr=p_prop; unit=Pa
    uint16_t  p_tunnel           ;//26  @rule: name=Pressure; expr=p_tunnel; unit=Pa
    int16_t  p_abs               ;//28  @rule: name=Pressure; expr=p_abs; unit=Pa
    int16_t  v_prop              ;//30  @rule: name=Propeller_Windspeed; expr=v_prop/10; unit=m/s
    int16_t  v_tunnel            ;//32  @rule: name=Tunnel_Windspeed; expr=v_tunnel/10; unit=m/s
    int16_t  temp_eng            ;//34  @rule: name=Temp Engine; expr=temp_eng/10; unit=C
    int16_t  temp_air            ;//36  @rule: name=Temp Air; expr=temp_air/10; unit=C
    uint16_t air_ro              ;//38  @rule: name=Air Density; expr=air_ro/10000; unit=kg/m³
    int16_t  pwm_act             ;//40  @rule: name=PWM_Output; expr=pwm_act; unit=C                
    uint8_t  ck                  ;//41
} raw ={41, 2};

struct struct_scaling        
{
    uint8_t  length              ;//1
    uint8_t  ID                  ;//2
    uint8_t  flag1       : 1     ;//3
    uint8_t  flag2       : 1     ;//4
    int      thrust_o            ;//8
    float    thrust_s            ;//12
    int      torque_o            ;//16
    float    torque_s            ;//20
    int      voltage_o           ;//24
    float    voltage_s           ;//28
    int      current_o           ;//32
    float    current_s           ;//36
    int      p_prop_o            ;//40
    float    p_prop_s            ;//44
    int      p_tunnel_o          ;//48
    float    p_tunnel_s          ;//52
    int      temp_eng_o            ;//56
    float    temp_eng_s            ;//60
    int      temp_air_o            ;//64
    float    temp_air_s            ;//68
     uint8_t  ck                  ;//37 
} cal ={69, 3};



uint8_t* struct_id[]  = {
                           &sys.length,     //ID0
                           &values.length,   //ID1
                           &raw.length,      //ID2
                           &cal.length,      //ID3
                        };  