#include "mbed.h"

typedef struct  
{
    uint16_t voltage_act;       // Actual CAP Voltage
    uint16_t voltage_low;       // Switch to full current
    uint16_t voltage_mid;       // Switch to medium current
    uint16_t voltage_high;      // Switch to minimum current
    uint16_t voltage_max;       // Stopp loading
    uint16_t voltage_down;      // reduce Voltage (CAP down)
    uint16_t current_low;       // minimum current
    uint16_t current_mid;       // medium current
    uint16_t current_high;      // high current
} struct_cap;

typedef struct 
{
    uint16_t air_needed;
    uint16_t current_act;
    uint16_t current_load;
    uint16_t temp_act;          
    uint16_t temp_max;
    uint16_t voltage_act;
    uint16_t voltage_max; 
} struct_fuelcell;

typedef struct 
{ 
    bool     fan_override;
    uint16_t fan_over_pwm; //name
    uint16_t fan_p;
    uint16_t fan_i;
    uint16_t fan_thr;
    short    fan_up;        //add
    short    fan_up_count;  //add
    short    fan_pwm;
    uint16_t fan_pwm_act;
    bool     pump_override;
    uint16_t pump_over_pwm; //name
    uint16_t pump_min;
    uint16_t pump_p;
    uint16_t pump_i;
    short    pump_up;       //add
    short    pump_up_count; //add
    short    pump_pwm;
    uint16_t pump_pwm_act;
    uint16_t temp_out;
} struct_h2o;

typedef struct 
{
    uint16_t current_act;
    uint16_t current_delta;
    uint16_t current_load;
    uint16_t i;                     // added
    uint16_t pwm;
    uint16_t pwm_act;
    uint16_t temp_act;
    uint16_t temp_max;
} struct_mosfet;

typedef struct 
{
    uint16_t air_current; 
    uint16_t air_needed;
    uint16_t water_created; //name
    uint16_t back_lower;
    uint16_t delta_t;
    uint16_t lambda;
    uint16_t lambda_max;
    uint16_t lambda_min;
    short    lambda_delta;
    short    lambda_delta_sum;
    bool     pump_on;
    bool     pump_override;
    uint16_t pump_over_load; //name
    uint16_t pump_load;      //name
    uint16_t pump_load_act;  //name
    short    pump_up;
    short    pump_up_count;
    uint16_t pump_pwm_1;
    uint16_t pump_pwm_2;
    bool     pump_dual;     //name
    uint16_t pump_dual_on;  //added
    uint16_t pump_dual_off; //added
    uint16_t rh_out_delta
    uint16_t rh_pump_load;
    uint16_t rh_pump_min;          
    uint16_t rh_pump_max;        
    uint16_t rh_out_min;
    uint16_t rh_out_max;
    uint16_t rh_back_p;
    uint16_t rh_in;
    uint16_t rh_out;
    uint16_t temp_in;
    uint16_t temp_out;              // added
    uint16_t temp_calc;
    uint16_t water_extracted;
    uint16_t water_in;
    uint16_t water_out;
   
} struct_o2;

typedef struct 
{
    bool capdown;
    bool drive;
    bool master;
    bool safety;
} struct_switch;

typedef struct 
{
    bool cap_down_load;
    bool cap_down_reset;
    bool cap_load;
    bool cap_voltage_reset;
    bool fuelcell;
    bool fc_overtemp;
    bool fc_overvoltage;
    bool load;
    bool load_act;
    bool load_reset;
    bool mosfet;
    bool mos_overtemp;
    bool run;
    bool temp;
    bool voltage;
    uint16_t count;
    uint16_t h2_analog;
    uint16_t safety_V;
    uint16_t current_out;
} struct_system;

typedef struct 
{
    bool o2_in;
    bool o2_out;
    bool mosfet_temp;
    bool fc_voltage;
    bool cap_voltage;
    bool mosfet_cur;
    bool h2o_temp_out;              
    bool t_1;
    bool t_2;
    bool t_3;
    bool t_4;
    bool t_5;
    bool t_6;
    bool t_7;
    bool t_8;
    bool o_1;
    bool o_2;
    bool o_3;
    bool o_4;
    bool o_5;
    bool o_6;
    bool o_7;  
}struct_error;

/*
struct_cap      cap;
struct_fuelcell fuelcell;
struct_h2o      h2o;
struct_mosfet   mosfet;
struct_o2       o2;
struct_switch   switches;
struct_system   sys;
struct_error    error;
*/
