#include "mbed.h"

class Counter {
public:
    /** Create an Counter with period read for low counts
     * 
     * @param pin is the MC pin for the Interrupt Input 
     */
    
    Counter(PinName pin, int count_per_round);
 
    /** Stores Counts per Second for last counting interval
     */
    float rps;
    int no_count;


private:

    void increment();
    
    void do_calc();
    
    InterruptIn _interrupt;
    Ticker      _base;
    Timer       _time;
    
    volatile int _count;
    volatile int _count_per_round;
    float _period;
    
};