#include "counter.h"


    /** Create an Counter with period read for low counts
     * 
     * @param pin is the MC pin for the Interrupt Input 
     */ 
Counter::Counter(PinName pin, int count_per_round) : _interrupt(pin), _count(0), _period (100000000) {        // create the InterruptIn on the pin specified to Counter
        _count_per_round = count_per_round;
        _interrupt.rise(this, &Counter::increment); // attach increment function of this counter instance
        _base.attach(this, &Counter::do_calc,0.01);
        _time.start();
        
    }

    /** Counter up on Riese Interrupt 
     *  Read periode time
     */ 

void Counter::increment() {
        if (_count < _count_per_round)
         {_period = ((_period * _count         ) + _time.read_us()) / (_count + 1);}
         else
         {_period = ((_period * _count_per_round) + _time.read_us()) / (_count_per_round + 1);}
        _count++;
        _time.reset(); 
    }

void Counter::do_calc() {   
        if (_count > 0)
         {
          rps = (1000000/(_period * _count_per_round));                             
          _count = 0;
          no_count = 0;
         }
        else
         {
          no_count++;
         }
        if (_time.read_ms() > 2000) _period = 100000000;
    }