#include "mbed.h"

class CD4052 {
    public:
        
        /** Create a new interface for an CD4052
         *
         * @param LB is the pin for the lower Selector Byte 
         * @param HB is the pin for the lower Selector Byte
         * @param X  is the pin for X - Group connected to MC
         * @param Y  is the pin for Y - Group connected to MC
         */
        CD4052(PinName _LB, PinName _HB, PinName _X, PinName _Y);

        DigitalOut LB;
        DigitalOut HB;
        AnalogIn   X;
        AnalogIn   Y;
        /** sets Channel
         * 
         * @param cha Number of Channel to Set
         *
         */
        void channel(char cha);
        
        /** read Channel X as integer
         */
        unsigned int x_i(void);
        
        /** read Channel X as integer
         */
        unsigned int y_i(void);
        
        /** read Channel X as float
         */
        float  x_f(void);
        
        /** read Channel X as float
         */
        float  y_f(void);
        
        /** read Channel X as Bool
         */
        bool   x_d(void);
        
        /** read Channel X as Bool
         */
        bool   y_d(void);
        
    private:
        
};