#include "CD4052.h"   
   
        /** Create a new interface for an CD4052
         *
         * @param LB is the pin for the lower Selector Byte 
         * @param HB is the pin for the lower Selector Byte
         * @param X  is the pin for X - Group connected to MC
         * @param Y  is the pin for Y - Group connected to MC
         */
        CD4052::CD4052(PinName _LB, PinName _HB, PinName _X, PinName _Y):LB(_LB),HB(_HB),X(_X),Y(_Y)
        {
         channel(0);   
        }
        
        /** sets Channel
         * 
         * @param cha Number of Channel to Set
         *
         */
        void CD4052::channel(char cha)
        {
         LB = cha&0x01;
         HB = cha&0x02;
        }   
        
        /** read Channel X as integer
         */
        unsigned int CD4052::x_i(void)
        {
         return X.read_u16();  
        }
        
        /** read Channel X as integer
         */
        unsigned int CD4052::y_i(void)
        {
         return Y.read_u16();  
        }
        
        /** read Channel X as float
         */
        float  CD4052::x_f(void)
        {
         return X.read();  
        }       
        
        /** read Channel X as float
         */
        float  CD4052::y_f(void)
        {
         return Y.read();  
        }
                
        /** read Channel X as Bool
         */
        bool   CD4052::x_d(void)
        {
         if (X.read_u16()>>8)
         return 1;
         else
         return 0 ; 
        }
                
        /** read Channel X as Bool
         */
        bool   CD4052::y_d(void)
        {
         if (Y.read_u16()>>8)
         return 1;
         else
         return 0;   
        }        