/*H****************************************************************************
 * FILENAME :        i2c_eeprom.h                                             *
 *                                                                            *
 * DESCRIPTION :                                                              *
 *       Simple library for external I2C EEEPROM.                             *
 *                                                                            *
 * AUTHOR :    Olli Vanhoja        START DATE :    2011-02-17                 *
 ******************************************************************************
 *
 * CHANGES :
 *
 * VERSION DATE       WHO            DETAIL
 * 0.1     2011-02-21 Olli Vanhoja   Initial release version
 * 0.2     2011-02-21 Olli Vanhoja   *Added possibility change I2C speed
 *                                   *Added external reset pin and autoreset
 *                                    for read function. Thanks to Jon Ward.
 *                                   *Documentational comments added.
 * 0.3     2011-02-21 Olli Vanhoja   *Auto-reset for all error conditions
 *
 *H*/

#ifndef I2C_EEPROM_H
#define I2C_EEPROM_H

/** I2C EEPROM access class
 * 
 * This class is used for communication with I2C EEPROM chip.
 */
class i2c_eeprom {
private:
    int i_i2c_address; // I2C harware address
    void autoreset();
public:
    /** Initialize communication
    *
    * @param hwAddr Harware address of the I2C EEPROM chip.
    * @param speed I2C bus speed.
    */
    i2c_eeprom(int hwAddr, int speed);
    
    /** Write to I2C EEPROM
    *
    * Write any length of bytes to external EEPROM.
    *
    * @param *data Array of bytes.
    * @param iAddr Memory address.
    * @param n Write n bytes.
    */
    void write(char *data, uint16_t iAddr, unsigned int n);
    
    /** Read from I2C EEPROM
    *
    * Read any length of bytes from external EEPROM.
    *
    * @param iAddr Memory address.
    * @param n Read n bytes.
    * @param *out Returns array of bytes.
    */
    void read(uint16_t iAddr, uint16_t n, char *out);
};

#endif
