#include "bitmap.h"

#define X_MAX 160
#define Y_MAX 32

extern Serial pc(USBTX, USBRX);

bitmapImage::bitmapImage(char *inputFilename)
{
    filename = inputFilename;
    
    pc.printf("Opening file %s...", filename);
    fp = fopen(filename, "rb");
    if(fp != NULL)
        pc.printf(" OK\n\r");
    else {
        fclose(fp);
        error("");
    }
    
    // check to see if it is a valid bitmap file
    if(fgetc(fp)!='B' || fgetc(fp)!='M')
    {
        fclose(fp);
        error("");
    }
    
    //fseek(fp, 0L, SEEK_END);

    // Get BMP info
    fileInfo.cols = readImageInfo(0x12, 4);
    fileInfo.rows = readImageInfo(0x16, 4);
    fileSize = readImageInfo(2, 4);
    fileInfo.offset = readImageInfo(0x0A, 4);
    fileInfo.bitsPP = (uint16_t)readImageInfo(0x1C, 2);

    // Print info
    pc.printf("\n\rBMP file %s:\n\r", filename);
    pc.printf("Width: %d\n\r", fileInfo.cols);
    pc.printf("Height: %d\n\r", fileInfo.rows);
    pc.printf("File size: %ld\n\r", fileSize);
    pc.printf("Offset: %d\n\r", fileInfo.offset);
    pc.printf("Bits per pixel: %d\n\r", fileInfo.bitsPP);
    //pc.printf("Vector size: %d\n\r", vectorSize);
}

bitmapImage::~bitmapImage()
{
    fclose(fp);
}

void bitmapImage::drawImage(gfxLcd *glcd, int xOffset, int yOffset)
{
    // Start at beginning of raster data
    fseek(fp, fileInfo.offset, SEEK_SET);
    int32_t offsettedX, offsettedY;
    
    uint32_t x=0, y=fileInfo.rows-1;
    for(uint32_t index=0; index < fileInfo.rows*(fileInfo.cols/8); index++)
    {
        char c=fgetc(fp);
        for(char b=0; b < 8; b++)
        {
            char mask = 0x80 >> b;
            offsettedX = (int32_t)x+xOffset;
            offsettedY = (int32_t)y+yOffset;
            
            if((offsettedX <= X_MAX) && (offsettedY <= Y_MAX) && (offsettedX >= 0) && (offsettedY >= 0))
            {
                glcd->putPixel(offsettedX, offsettedY, ~c&mask);
            }
            x++;
            
            if (x == fileInfo.cols)
            {
                x=0;
                y--;
            }
            if (y == 0)
                return;
        }
    }
}

uint32_t bitmapImage::readImageInfo(long offset, int n)
{
    long value = 0L;
    char c;
    int  i;

    fseek(fp, offset, SEEK_SET);

    for(i=0; i < n; i++)
    {
        fread(&c, sizeof(char), 1, fp);
        /* calculate value based on adding bytes */
        value = (long)(value + (c)*((long)pow((long double)256, (int)(i))));
    }
    
    return value;
}
