/** @file lcd.h */
#ifndef LCD_H_
#define LCD_H_

#include "mbed.h"

union Dots
{
    uint16_t word;
    char byte[2];
}; 

struct GbufMem
{ 
    bool refresh; // Refresh needed?
    Dots dots[10][32]; // 160x32 pixels LCD
};

/** gfxLcd class
 * 
 * This class is used for controlling the LCD.
 */
class gfxLcd
{
private:
    void write(bool rs, char d);
public:
    GbufMem fbuf; /**< Frame buffer for the LCD */
    
    /** Initialize LCD
    *
    */
    gfxLcd();
    
    /** Initialize LCD
    *
    */
    void init();
    
    /** Fill screen with black or white
    *
    * @param color true = black, false = white
    */
    void fillScreen(bool color);
    
    /** Set/clear pixel in framebuffer
    *
    * @param x x position of the pixel.
    * @param y y position of the pixel.
    * @param color true = set (black), false = clear (white)
    */
    void putPixel(char x, char y, bool color);
    
    /** Refresh display
    *
    */
    void update();
};
#endif
