/** @file bitmap.h */
#ifndef BITMAP_H_
#define BITMAP_H_

#include "mbed.h"
#include "lcd.h"

/** File info structure
*/
struct sBitmapInfo {
    uint32_t rows;    /**< Number if rows in bitmap. */
    uint32_t cols;    /**< Number of colums in bitmap. */
    uint32_t offset;
    uint16_t bitsPP;
};

/** bitmapImage class
 * 
 * This class is used for drawing BMP images.
 */
class bitmapImage {
private:
    char *filename;
    FILE *fp;
    unsigned long fileSize;  /**< BMP file size. */
    
    /** Read integer value from file
    *
    * @param offset Byte offset.
    * @param n Number of bytes.
    * @returns Long integer.
    */
    uint32_t readImageInfo(long offset, int n);
public:
    sBitmapInfo fileInfo; /**< File info */

    /** Open BMP bitmap file
    *
    * @param *inputFilename Path to BMP file.  
    */
    bitmapImage(char *inputFilename);
    
    ~bitmapImage();
    
    /** Draw bitmap to the LCD
    *
    * \note There is no image buffer in this class instead the image
    *       is read from the fs every time it's drawn. This should
    *       be still fast enough as mBeds flash is still faster than
    *       the LCD.
    *
    * \warning This class doesn't understand padding so images must be
    *          resized to size where paddings isn't needed. Also because
    *          of one bit BMP format the iamge width should be divisiable
    *          by 8.
    *
    * @param *glcd Reference to gfxLcd object.
    * @param xOffset Start drawing from point x.
    * @param yOffset Start drawing from point y.
    */
    void drawImage(gfxLcd *glcd, int xOffset, int yOffset);
};
#endif
    