#include "mbed.h"
#include "SSD1306.h"
#include "Servo.h"
#include "HCSR04.h"

#define SCLK    PTC5
#define IO      PTC4
#define CE      PTC3
#include "DS1302.h"

Servo myservo(PTD4);
Timer timer;
AnalogIn   ain(A0);
DS1302 clk(SCLK, IO, PTC3);

#define D_SDA                  PTC11
#define D_SCL                  PTC10
I2C i2c(D_SDA, D_SCL);

SPI spi(PTD2, PTD3, PTD1); //MOSI MISO Y SCLK
//DigitalOut K(PTD5);
Serial pc(USBTX, USBRX);

char x[10];
int i=0,cs2=0;
int dato3;
uint16_t adcvalue ;
float  voltaje ;

SSD1306 oled = SSD1306(i2c, SSD1308_SA0);


int main()
{

#ifdef INITIAL_RUN
    clk.set_time(1512485768);
#endif

    char storedByte = clk.recallByte(0);
    printf("Stored byte was %d, now increasing by one\r\n", storedByte);
    clk.storeByte(0, storedByte + 2);

    HCSR04 sensor(PTD5, PTA13);
    sensor.setRanges(10, 110);
    pc.printf("Min. range = %g cm\n\rMax. range = %g cm\n\r",
              sensor.getMinRange(), sensor.getMaxRange());

    while(1) {
        time_t seconds = clk.time(NULL);
        sprintf(x,"%s\r", ctime(&seconds));
        oled.writeString(0, 5, x);//Fecha publicada

        //Inicio termocupla
        DigitalOut (PTD0, 1);
        spi.format(8,3);
        spi.frequency(1000000);
        wait_ms(700);
        DigitalOut (PTD0, 0);
        spi.write(0x00);
        int dato = spi.write(0xFF);
        int dato2 = spi.write(0xFF);
        dato3 = (((dato2*256 + dato)/8)/4);
        //pc.printf("%d\n", dato3);

        DigitalOut (PTD0, 1);
        oled.writeProgressBar(2,4,dato3*2);
        oled.writeString(2, 8, "Temp.");
        //Fin termocupla

        //inicio servo
        adcvalue = ain.read_u16();
        voltaje = ((adcvalue*100)/65536);
        myservo = voltaje/100.0;
        oled.writeLevelBar(6,4,voltaje);
        oled.writeString(6, 8, "Ang.");
        //fin servo


        //INICIO ULTRASÓNICO
        timer.reset();
        timer.start();
        sensor.startMeasurement();
        while(!sensor.isNewDataReady()) {
            // wait for new data
            // waiting time depends on the distance

        }
        //pc.printf("Distance: %5.1f cm\r\n", sensor.getDistance_cm());
        pc.printf("%u\n", sensor.getDistance_cm());
        timer.stop();
        wait_ms(500 - timer.read_ms());
        oled.writeProgressBar(4,4,sensor.getDistance_cm());
        oled.writeString(4, 8, "Dist.");
        //FIN ULTRASONICO
        wait_ms(1000);



    }

}