#ifndef PID_H
#define PID_H


#include "mbed.h"

class DaclePID{

public:

    /* Constructeur du DaclePID
        Kc: Coeff Kc
        Ti: Coeff Ti
        Td: Coeff Td
        Interval: Intervalle de temps */
      DaclePID(float Kc, float Ti, float Td, float interval);
      
      /* Fonction qui permet de regler les coeff du PID */
      void setCoeff(float Kc, float Ti, float Td);
      
      /* Fonction qui permet au DaclePID de calculer la commande
            en entrée: Erreur */
      void setInputLimits(float minInput, float maxInput);
      void setOutputLimits(float minOutput, float maxOutput);
      void setConsigne(float consigne);
      void setBiais(float biais);
      float dacalcul(float erreur);
      
private:

    float Kc_;
    float Ti_;
    float Td_;
    
    float dT_;
    float accError_;  //Erreur accumulée (Pour l'intégrale de l'erreur)
    float pidSortie_; //Commande
    float erreurPres_; //Erreur au temps d'avant (pour la dérivée)
    
    float minInput_, maxInput_, minOutput_, maxOutput_;
    float consigne_, biais_;
    
    float to01(float x);
    float from01(float x);
    
};

#endif