#include "DaclePID.h"


DaclePID::DaclePID(float Kc, float Ti, float Td, float interval) {

    setCoeff(Kc, Ti, Td);
    dT_ = interval;

    accError_ = 0.0;
    pidSortie_ = 0.0;
    erreurPres_ = 0.0;
    minInput_=0; maxInput_=3.3;
    minOutput_=0; maxOutput_=3.3;
    consigne_=0;
    biais_=0;
    
}

void DaclePID::setCoeff(float Kc, float Ti, float Td){

    Kc_ = Kc;
    Ti_ = Ti;
    Td_= Td;

}

void DaclePID::setInputLimits(float minInput, float maxInput){
    minInput_=minInput; maxInput_=maxInput;
}

void DaclePID::setOutputLimits(float minOutput, float maxOutput){
    minOutput_=minOutput; maxOutput_=maxOutput;
}

float DaclePID::dacalcul(float erreur){
    
    float _erreur = to01(erreur)-to01(consigne_);
    
    accError_ += _erreur;
    float dErreur = (_erreur - erreurPres_) /dT_;

    pidSortie_ = Kc_ * (_erreur + (Ti_ * accError_ * dT_) + (Td_ * dErreur));

    erreurPres_ = _erreur;

    return from01(pidSortie_) - from01(biais_);

}

float DaclePID::to01(float x){
        return (x-minInput_)/(maxInput_-minInput_);
}
    
float DaclePID::from01(float x){
        return (maxOutput_-minOutput_)*x + minOutput_;
}
