#ifndef _GURVIMU_H_
#define _GURVIMU_H_

#include "mbed.h"
#include "MPU6050.h"

class GurvIMU {
    private:
        //Variables
        MPU6050 mpu;
        float twoKp;            // 2 * proportional gain (Kp)
        float twoKi;            // 2 * integral gain (Ki)
        float integralFBx, integralFBy, integralFBz; // integral error terms scaled by Ki
        float q0, q1, q2, q3;   // quaternion of sensor frame relative to auxiliary frame
        float ax, ay, az, gx, gy, gz;
        float sample_freq;
        float offset[6];
        Timer timer_us;
        float dt_us;
        float cycle_nb;
        
        
        //Functions
        void getOffset();
        
        void AHRS_update(float gx, float gy, float gz, float ax, float ay, float az);
        void getQ(float * q);

    public:
        GurvIMU();
        void init();
        void getValues(float * values);
        void getYawPitchRollRad(float * ypr);
        void getVerticalAcceleration(float av);
        
};

//Fast Inverse Square Root
float invSqrt(float number);

#endif /* _GURVIMU_H_ */