#include "mbed.h"
#include "stdio.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED3);//Create variable for Led 3 on the mbed

// Character from the keyboard
char key;

// xbee
char X;
DigitalOut rst1(p8);  
Serial xbee(p9, p10);
DigitalOut rst(p8);


// LEDs
DigitalOut ledL(LED1);
DigitalOut ledR(LED4);


// -------------------- Callback Xbee receive ---------------------- //
void xbee_recv(){
    while(xbee.readable()) {
        if(xbee.getc() == 'R'){
            pc.printf("R%i\r\n", xbee.getc());
        }
        if(xbee.getc() == 'L'){
            pc.printf("L%i\r\n", xbee.getc());
        }
    }
}



// -------------------- Callback PC ---------------------- //
void pc_recv(){
   
    key=pc.getc();  
    
    //If the keypress was an arrow key                            
    if(key==0x1B) {                               
        key = pc.getc();                        
        if (key == 0x5B) { //Check again!
             key = pc.getc();
             switch(key) {  //Check to see which arrow key...                       
                case 0x41:                        
                    pc.putc('U');
                    xbee.putc('U');
                    break;
                case 0x42:                        
                    pc.putc('D');
                    xbee.putc('D');
                    break;
                case 0x43:                        
                    pc.putc('R');
                    xbee.putc('R');
                    break;
                case 0x44:                        
                    pc.putc('L');
                    xbee.putc('L');
                    break;
            }
        }
    }
    else{
        switch (key) {
            case '1': // key 1
                xbee.putc(key);
                break;
            case '2': // key 2
                xbee.putc(key);
                break;
            case '3': // key 3
                xbee.putc(key);
                pc.putc(key);
                break;
            case '4': // key 4
                xbee.putc(key);
                break;
            case 'U': // key U / GUI up
                xbee.putc(key);
                pc.putc(key);
                break;
            case 'D': // key D / GUI down
                xbee.putc(key);
                break;
            case 'L': // key L / GUI left
                xbee.putc(key);
                break;
            case 'R': // key R / GUI right
                xbee.putc(key);
                break;
            case 'A': // key U / GUI right
                xbee.putc(key);
                break;
            case 'B': // key D / GUI right
                xbee.putc(key);
                break;
            case 'C': // key L / GUI right
                xbee.putc(key);
                break;
            case 'E': // key R / GUI right
                xbee.putc(key);
                break;
            default:
                break;                   
        }
    }
}


// -------------------- Callback XBox controller ---------------------- //




int main() { 
    
    // Initialize Xbee
    rst1 = 0;
    wait_ms(1);
    rst1 = 1;
    wait_ms(1);
    
    pc.attach(&pc_recv, Serial::RxIrq);
    xbee.attach(&xbee_recv, Serial::RxIrq);
     
    while(1){  
        wait_ms(1);
    }
}

