/**
 ****************************************************************************
 * @file    main.cpp
 * @author  Jimmy MAINGAM
 * @version V0.0.1
 * @date    20/03/2019
 * @brief   Implementation file main 
 ****************************************************************************
 *This software has been developed to be used in AREM's robot for the cdfr 2019
 **/
 
 /* Includes ------------------------------------------------------------------*/

#include "mbed.h"
#include "pinMap.hpp"

#include "hardware.h"
#include "odometrie.h"
#include "reglages.h"
#include "deplacement.h"

#include "BrasPousser.h"
#include "Bras.h"
#include "Pompe.h"
#include "demarreur.h"
#include "Ecran.h"

#include "Strategie.h"
#include "AnalyseDistance.h"
#include "AnalyseArcLib.h"


/* Global Variables ---------------------------------------------------------*/   

//I2CSlave i2c(PIN_SDA, PIN_SCL);
extern Serial serial;
extern bool typeEvitement;
Serial capteursUART(A0,A1,2000000);
//Ticker lectureI2C;
extern event_callback_t afficherEcranCallback;
event_callback_t afficherCapteursCallback;

bool newOrder = false;
bool detectionUltrasons = false;

/* Public Functions ------------------------------------------------------------------*/

//void afficherI2C();
void recupererCapteurs(int events);

/* Main  -----------------------------------------------------------------------------*/

int main()
{
    Pompe pompe(PIN_POMPE);
    Demarreur demarreur(PIN_DEMARREUR);
    Bras brasGauche(PIN_SERVO_BRAS_GAUCHE, GAUCHE);
    Bras brasDroit(PIN_SERVO_BRAS_DROIT, DROIT);
    BrasPousser brasPousserGauche(PIN_SERVO_PALETS_GAUCHE, GAUCHE);
    BrasPousser brasPousserDroit(PIN_SERVO_PALETS_DROIT,DROIT);
    deplacement robot;
    
    robot.initialisation();
    
    AnalogIn Ain(A5);
    if(Ain.read() < 0.68f)
    {
       return 0;   
    }
    
    pc.printf("SystemCoreClock is %d Hz\r\n", SystemCoreClock);  
    
    afficherEcranCallback.attach(afficherEcran); 
    afficherCapteursCallback.attach(recupererCapteurs);
    
    serial.read((uint8_t*)buffer, TAILLE, afficherEcranCallback, SERIAL_EVENT_RX_COMPLETE);
    capteursUART.read((uint8_t*)bufferCapteurs, TAILLEBUFFERCAPTEURS, afficherCapteursCallback, SERIAL_EVENT_RX_COMPLETE);
    
    /*setEmplacementTest();
    init_odometrie();
    typeEvitement = ARC;
    wait(10);
    robot.va_au_point(100000,30000,0.0);*/
    while(1)
    {
        if(detectionUltrasons)
        {
            detectionUltrasons = false;
            writeCapteurs();
            //LectureI2CCarteCapteur(robot);
        }
        if(newOrder)
        {
            newOrder = false;
            executeOrderInit(robot, pompe, demarreur, brasGauche, brasDroit, brasPousserGauche, brasPousserDroit);
        }
    }
    return 0;
}


void recupererCapteurs(int events)
{
    //pc.write((uint8_t*)bufferCapteurs, TAILLEBUFFERCAPTEURS, NULL);
    detectionUltrasons = true;
    capteursUART.read((uint8_t*)bufferCapteurs, TAILLEBUFFERCAPTEURS, afficherCapteursCallback, SERIAL_EVENT_RX_COMPLETE);
    
}
/*
void afficherI2C()
{
    //On coupe la lecture écran lorsqu'on lit l'I2C pour éviter les conflits avec le ticker (on le coupe aussi)
    serial.abort_read();
    lectureI2C.detach();
    
    i2c.read((char*)bufferCapteurs, TAILLEBUFFERCAPTEURS);
    pc.printf("%s\n", bufferCapteurs);
    
    //On renvoit ce qui est lu vers l'écran par liaison série
    writeCapteurs();
    
    //On réactive le ticker et la lecture des ordres de l'écran
    serial.read((uint8_t*)buffer, TAILLE, afficherEcranCallback, SERIAL_EVENT_RX_COMPLETE);
    lectureI2C.attach(&afficherI2C, 0.02);
}

//main

    //i2c.address(0x90);
     //i2c.read((char*)bufferCapteurs, TAILLEBUFFERCAPTEURS);*/
    //Réception des ordres écran : on attache la fonction afficherEcran qui est appelée lorsque le buffer de 11 est plein

    //Première initialisation du ticker
    //lectureI2C.attach(&afficherI2C, 0.02);


