#ifndef DEPLACEMENT_H
#define DEPLACEMENT_H

/**
 ****************************************************************************
 * @file    deplacement.h
 * @author  Guillaume Chauvon && Corentin Courtot #l'assert
 * @version V0.2.3
 * @date    22/05/2019
 * @brief   Implementation file for the deplacement of the robot
 ****************************************************************************
 *This software has been developed to be used in AREM's robot for the cdfr 2019
 **/
 
/* Includes ------------------------------------------------------------------*/
 

#include "BrasPousser.h"
#include "Pompe.h"

/* Constants -------------------------------------------------------------------*/

#define A_GAUCHE 1
#define A_DROITE 0
#define TAILLE_TAB 250

/* structures-----------------------------------------------------------------------*/

struct Coordonnees
{
            double x; 
            double y;
};



/* Class BrasPousser ------------------------------------------------------------------*/

class deplacement{
    public:
        deplacement();
        void initialisation(void);//init
        
        void rotation_rel(double angle_vise); // rotation relative angle positif pour tourner vers la gauche
        void rotation_abs(double angle_vise); //rotation absolue du robot
        void rotation_rel_pente(double angle_vise);
        void rotation_abs_pente(double angle_vise);
        
        void commande_vitesse(float vitesse_G, float vitesse_D); //set_PWM avec des vitesses flottantes.
        
        void vitesse_nulle_D(int zero); //coupe moteur droit
        void vitesse_nulle_G(int zero); //coupe moteur gauche
        void arreterRobot();
        void marche_arriere(int distance); // ligne droite en marche arriere, argument entier NEGATIF
        void ligne_droite_basique(long int distance); // ligne droite en marche avant, argument entier POSITIF
        
        void ligne_droite(long int distance, double x, double y, double cap);
        
       
         
        void poussette(float temps); // set PWM 150 pendant 1.5s 
        void arc(Coordonnees p1, Coordonnees p2, int sens);//p2 point final p1 point intermediaire
        int cercle(Coordonnees a,Coordonnees b, Coordonnees c);
        double int_ext_cercle(double x, double y);
        void va_au_point(double x,double y, double cap);
        double recup_angle_entre_trois_points_213(double x1,double y1,double x2,double y2,double x3,double y3);
        void pente(long int distance, float vitesse, double angle_a_tourner);
        void pente_combo(double angle_pente, BrasPousser brasPousserGauche, BrasPousser brasPousserDroit, Pompe pompe);
        
        void evitement(double x, double y, double cap);    
    
    private:
        double point[3];
};

Coordonnees pointIntermediaire();
Coordonnees pointFinale();
#endif