#ifndef ANALYSEARCLIB_H
#define ANALYSEARCLIB_H
/**
 ****************************************************************************
 * @file    AnalyseArcLib.h
 * @author  Jimmy MAINGAM
 * @version V0.0.1
 * @date    15/05/2019
 * @brief   Implementation file to analyse the arc trajectory to avoid a robot
 ****************************************************************************
 *This software has been developed to be used in AREM's robot for the cdfr 2019
 **/
 
 /* Includes ------------------------------------------------------------------*/
 
#include "mbed.h"
#include "odometrie.h"

/* Constants -------------------------------------------------------------------*/

#define LONGUEUR_ROBOT_ADVERSE 300
#//define LARGEUR_ROBOT 230
#define LONGUEUR_ROBOT 150
#define DEMI_LARGEUR_ROBOT 115
#define DEMI_LONGUEUR_ROBOT_AVANT 120
#define DEMI_LONGUEUR_ROBOT_ARRIERE 30
#define MARGE 350

#define NB_POINT 49
#define TAILLE_BUFFER_POINT 50

#define PARLAGAUCHE 0
#define PARLADROITE 1

//Accélérateur zone 
#define AX1 500
#define AY1 0
#define BX1 2500
#define BY1 50

//Chaos violet zone 
#define AX2 850
#define AY2 1050
#define BX2 1150
#define BY2 1350 

//Chaos jaune zone 
#define AX3 1850
#define AY3 1050
#define BX3 2150
#define BY3 1350 

//distributeur violet zone 
#define AX4 450
#define AY4 1543
#define BX4 1050
#define BY4 1600 

//distributeur jaune zone 
#define AX5 1950
#define AY5 1543
#define BX5 2550
#define BY5 1600 

//limite  zone 
#define AX6 0
#define AY6 1600
#define BX6 3000
#define BY6 2000 

//depart  zone violet
#define AX7 0
#define AY7 300
#define BX7 450
#define BY7 1200 

//depart  zone jaune
#define AX8 2550
#define AY8 300
#define BX8 3000
#define BY8 1200 

//truc relou milieu
#define AX9 1460
#define AY9 1400
#define BX9 1540
#define BY9 1600 

//hors terrain
#define AX0 0
#define AY0 0
#define BX0 3000
#define BY0 2000 


#define SANS_OBSTACLE 1
#define AVEC_OBSTACLE 0


/* Global Variables ---------------------------------------------------------*/   


struct Robot
   {
    double Ax;
    double Ay;
    double Bx;
    double By;
    double Cx;
    double Cy;
    double Dx;
    double Dy;
   };
 
struct Point 
{
    double X;
    double Y;
}; 
 
   
struct Arc
  {
    double CentreX;
    double CentreY;
    double Rayon;
    
    double intervaleXd;
    double intervaleXf;
    double intervaleYd;
    double intervaleYf;
   };

/* Public Functions ------------------------------------------------------------------*/

void actualiserPosRobot(); //a implémenter après intégration avec odometrie.h 

void calculPosFinalGauche(int distanceUltrasonGauche); //calcul de la position finale après l'évitement par la gauche
void calculPosFinalDroite(int distanceUltrasonDroite); //calcul de la position finale après l'évitement par la droite

void calculPosInterParLaGauche();  //calcul d'un point intermédiaire par la gauche pour le futur arc 
void calculPosInterParLaDroite(); //calcul d'un point intermédiaire par la droite pour le futur arc

Robot setPosRobot(Point point, double capActuel); // calcul les coordonnées du robot dans l'expace sachant son point de départ
double calculercapActuel(Point P1, Point P2);

void afficherRobot(Robot robot); //fct d'affichage
void afficherArc(Arc arc); //fct d'affichage
void afficher(Point buffer[]); //fct d'affichage

bool arcPossible(); // vérification qu'un arc existe
Arc trouverArc(); //renvoie un arc (cercle) passant par les trois points

double trouverAngle(Arc arc); // renvoie l'angle totale de l'arc
double trouverAngleInit(Arc arc); //renvoie l'angle initial (attention ce n'est pas le cap)

Arc genererArcInterieur(Arc arc); // génère un arc intérieur à partir de trouverArc() prenant en compte la surface du robot
Arc genererArcExterieur(Arc arc); // génère un arc extérieur à partir de trouverArc() prenant en compte la surface du robot

int trouverIndicePointFinal(Point buffer[], double xF, double yF);
void modifierPointFinal(Point buffer[], int indice);

void recupererTableauPointArc(Arc arc, Point buffer[], bool type); //Discrétise les points d'un Arc en les stockant dans un buffer

bool estUnArc(Point tableau[], int indice); // a implémenter
bool lancerUnEvitementParArcGauche(int distanceUltrasonGauche, double xFinal, double yFinal); //fonction qui check si on peut faire un évitement par la gauche
bool lancerUnEvitementParArcDroit(int distanceUltrasonDroite, double xFinal, double yFinal); //fonction qui check si on peut faire un évitement par la gauche
#endif