// Librairies
#include "mbed.h"               // Standard
#include "MD25.h"               // Moteurs
#include "TextLCD.h"            // Ecran LCD
#include "HTU21D.h"             // Capteur Temperature / Humidite
// #include "VCNL40x0.h"        // Capteur Luminosite / Distance


// Declarations E/S //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DigitalIn bouton (USER_BUTTON);                                     // Bouton d'arret total du robot
DigitalIn bouton_poussoir(D9);                                      // Pin PC7 Bouton poussoir demarrage
DigitalIn cap_arret(PA_9);                                          // Pin PA9 capteur d'arret (Devant)
 
Serial pc(SERIAL_TX, SERIAL_RX);                                    // Port Serie avec le PC

TextLCD lcd(D2, D3, D4, D5, D6, D7,TextLCD::LCD20x4);               // Ecran LDC (rs, e, d4-d7)
MD25 i2c(I2C_SDA, I2C_SCL);                                         // Moteurs  :   100kHz clock, addr B0, reg 0=speedl, 1=speedr (0 (Full Reverse) 128 (Stop) 255 (Full Forward). 15=mode (set to 0 default)
HTU21D temphumid(D14, D15);//HTU21D temp(I2C_SDA, I2C_SCL);                                    // Capteur Temperature / Humidite 
//VCNL40x0 VCNL40x0_Device (I2C_SDA, I2C_SCL, VCNL40x0_ADDRESS);      // Capteur Luminosite / Distance Define SDA, SCL pin and I2C address 


// Fonctions pour les Moteurs ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Prototypes ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    void init_motors (void);                            // Initialisation des Moteurs
    void setSpeed (int speedMotor1, int speedMotor2);   // Definir Vitesse moteurs

// Definition ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    void init_motors(void) {
        i2c.setMode(0);         // MODE 0, 0=marche arriere 128=stop 255=marche arriere vmax
        i2c.setCommand(32);     // 0x20 reset encoders
        i2c.setCommand(50);     // 0X32 Disable time out
        //i2c.setCommand(32);   // 0x20 reset encoders
        //i2c.setCommand(48);   // 0X32 Disable speed regulation
    }
     
    void setSpeed (int vitMotor1, int vitMotor2) {
        i2c.setSpeedRegisters(vitMotor1,vitMotor2); 
    }
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


// Fonction d'Initialisation //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void initialisations () { 
    lcd.printf("Initialisation\n");   
    pc.printf("Initialisation\n\r");
    bouton.mode (PullUp);                       // Bouton Utilisateur 
    bouton_poussoir.mode (PullUp);              // Bouton Poussoir
    init_motors();                              // Initialise Moteur


    
    pc.printf("Fin Initialisation\n\r");
    lcd.printf("Fin Initialisation\n");
    wait(1);
}

// Fonction Principale //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int main() { //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    pc.printf("\n\n\n\n\n\n\n\n Majord'home: Hello! Programme\n\r"); //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    lcd.printf("Majord'home: Hello!\n"); //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    wait(1); //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    initialisations (); //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
// Declaration Variables Locales
    float Ftemp, Ctemp, Ktemp, Humid;       // Temperature et humidite
    
    
// Init des Temperatures et Humidite
    Ftemp = temphumid.sample_ftemp();       Ctemp = temphumid.sample_ctemp();       Ktemp = temphumid.sample_ktemp();       Humid = temphumid.sample_humid();
    
    
// Boucle Infinie //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    lcd.cls();  lcd.locate(0,0);
    lcd.printf("%.2f C  %.2f %% Hum", Ctemp, Humid); lcd.locate(0,1);
    lcd.printf("%.2f F  %.2f K", Ftemp, Ktemp); lcd.locate(0,2);
    lcd.printf("Debut While(1)");
    pc.printf("Debut While(1)\n\r");
    wait(3); lcd.cls();  lcd.locate(0,0);
    
    while(1) { //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        lcd.locate(0,0);
        Ctemp = temphumid.sample_ctemp();   Humid = temphumid.sample_humid();
        lcd.printf("%.2f C  %.2f %% Hum", Ctemp, Humid);
        
               
        
        lcd.locate(0,2);
        cap_arret.read();
        if (cap_arret==0) {
            lcd.printf("A=0");
            setSpeed(128,128);
            }
        else if (cap_arret==1) {
            lcd.printf("A=1");
            //setSpeed(60,60);
            }
            
        
    }
}
