#include "mbed.h"

Serial pc(SERIAL_TX, SERIAL_RX);    // Port Serie Avec le PC

// Digital I/O
DigitalOut Led1(D7);                // Port D7 : Sortie, nom=>Led1
DigitalOut Led2(D8);
DigitalOut Led3(D2);
DigitalOut Led4(D3);

DigitalIn Inter(D5);                // Port D5 : Entree, nom=>Inter

void initialisations () {
    pc.printf("Initialisation\n\r");
    Inter.mode(PullUp); // Bouton Poussoir Normalement Ouvert a l'etat haut
    
    
    pc.printf("Fin Initialisation\n\r");
}

int main() {
    pc.printf("Lancement Programme\n\r");
    initialisations ();
    // Declaration Variables Locales
    int allume = 0, i=0;
    float temps = 0.5;
    
    
    pc.printf("Debut While(1)\n\r");
    while(1) {
        pc.printf("%d\n\r",i++);
        switch(allume)
        {
            case 0:
                Led1 = 1;   Led2 = 0;   Led3 = 0;   Led4 = 0;
                allume = 1;
                wait (temps);
                break;
            case 1:
                Led1 = 0;   Led2 = 1;   Led3 = 0;   Led4 = 0;
                allume = 2;
                wait (temps);
                break;
            case 2:
                Led1 = 0;   Led2 = 0;   Led3 = 1;   Led4 = 0;
                allume = 3;
                wait (temps);
                break;
            case 3:
                Led1 = 0;   Led2 = 0;   Led3 = 0;   Led4 = 1;
                allume = 0;
                wait (temps);
                break;
            default:
                Led1 = 0;   Led2 = 0;   Led3 = 0;   Led4 = 0;
                allume = 0;
                wait (temps);   
        } 
        
        if (Inter == 0)
            temps = 0.5;
        else
            temps = 1;
    }
}
    