/* This code based on mbed TextLCD Library, for a 4-bit LCD based on HD44780,
 * Copyright (c) 2007-2010, sford, http://mbed.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef _MENBEDDISPLAYHD44780_H_
#define _MENBEDDISPLAYHD44780_H_

#include "mbed.h"
#include "menbedDisplay.h"

class MenbedDisplayHD44780 : public MenbedDisplay {
public:

    /** LCD panel format */
    enum LCDSize {
        LCD16x2,   /**< 16x2 LCD panel */
        LCD16x2B,  /**< 16x2 LCD panel alternate addressing */
        LCD20x2,   /**< 20x2 LCD panel */
        LCD20x4,   /**< 20x4 LCD panel (default) */
    };

    MenbedDisplayHD44780 (PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7, LCDSize size = LCD20x4);
    
    virtual bool writeLine (const char *line, uint8_t row);
    virtual void showUpArrow (bool show);
    virtual void showDownArrow (bool show);
    virtual uint8_t getLines (void);
    virtual uint8_t getLineLength (void);
    
protected:
    enum ArrowSelectorChar {
        CharUP,
        CharUP_SELECT,
        CharSELECT,
        CharDOWN_SELECT,
        CharDOWN
    };

    DigitalOut rs, e;
    BusOut d;
    LCDSize size;
    
    bool upArrowVisible, downArrowVisible;
    bool topLineSelected, bottomLineSelected;
    int cursorCol, cursorRow;

    bool gotoPosition(int row, int column);
    void clear();
    void cursorOn();
    void cursorOff();

    int address(int column, int row);
    void writeByte(int value);
    void writeCommand(int command);
    void writeData(int data);
    void loadCustomChars(void);
    int rows();
    int columns();
};

#endif /* _MENBEDDISPLAYHD44780_H_ */