#include "mbed.h"
#include "include/menbedMenuParam.h"

MenbedMenuParam::MenbedMenuParam (
    float (*initValFcn)(void), void (*finalValFcn)(float),
    bool liveUpdate, float min, float max,
    float inc) : 
    initValFcn(initValFcn), finalValFcn(finalValFcn), _liveUpdate(liveUpdate),
    _min(min), _max(max), _inc(inc)    
{
}

float MenbedMenuParam::getVal (void)
{
    if (initValFcn == NULL)
        return 0.0;
        
    return initValFcn();
}

void MenbedMenuParam::setVal (float v)
{
    if (finalValFcn == NULL)
        return;
        
    finalValFcn(v);
}