#include "mbed.h"
#include "include/menbedMenuMessage.h"
#include "include/menbedDisplayer.h"

MenbedDisplayer::MenbedDisplayer (MenbedDisplay *display) :
    display(display)
{
}


void MenbedDisplayer::update (MenbedMenuMessage *menuMessage)
{
    char *text = new char[display->getLineLength()+1];

    for (int i=0; i<display->getLines(); i++)
    {
        extractLine (menuMessage->text, i, text);
        display->writeLine (text, i);
    }
    
    // Print the up and down arrows if requested
    display->showUpArrow (menuMessage->showUpArrow);
    display->showDownArrow (menuMessage->showDownArrow);
    
    delete[] text;
}


void MenbedDisplayer::extractLine (char *catenatedText, uint8_t lineNum,
        char *extractedText)
{
    char *subText, *endText;
    size_t bytesToCopy;

    extractedText[0] = '\0';

    // Return with just a blank line if the line number to be extracted exceeds
    // the number of lines in the menu
    if (lineNum > display->getLines() - 1)
        return;

    // We loop through the catenatedString finding each \n.  These \n
    // characters separate the substrings that we are trying to extract.
    subText = catenatedText;
    while (lineNum > 0)
    {
        subText = strchr (subText, '\n');

        // If the \n character was not found, the catenatedText string does not
        // contain enough \n-separated substrings.
        if (subText == (char *)NULL)
        {
            extractedText[0] = '\0';
            return;
        }

        // Increment the subText pointer because the strchr() command returned
        // a pointer to the \n character found, but next time through the loop
        // we want to find the next \n, not the same \n again.
        subText++;
        lineNum--;
    }

    // If there are strings following the one we are trying to extract, we
    // change the \n terminating the string to be extracted into a \0 so that
    // we can use the strlen function to determine the length of the string
    // we are trying to extract.  If there are no additional \n-separated
    // strings following the one we are attempting to extract, strlen should
    // work on subText without modification.
    if ((endText = strchr (subText, '\n')) != (char *)NULL)
        bytesToCopy = endText - subText + 1;
    else
        bytesToCopy = strlen(subText);

    // Copy the string found in the \n-separated substring number specified by
    // the lineNum parameter to the extracted string.
    strncpy (extractedText, subText, bytesToCopy);

    // Replace the \n at the end of extractedText string with a \0
    extractedText[bytesToCopy-1] = '\0';
}
