#include "mbed.h"
#include "include/menbed.h"

Menbed::Menbed (PinName select, PinName down, PinName up, PinName cancel,
    MenbedMenu *rootMenu,
    MenbedDisplay *display)
{
    MenbedButtonHandlerTimespec *timespec = new MenbedButtonHandlerTimespec();
    
    displayer = new MenbedDisplayer (display);
    navigator = new MenbedNavigator (rootMenu, displayer);
    buttonHandler = new MenbedButtonHandler (select, down, up, cancel, timespec, navigator);
    refresher = new MenbedRefresher (navigator);
}

Menbed::Menbed (PinName select, PinName down, PinName up,
    MenbedMenu *rootMenu,
    MenbedDisplay *display)
{
    MenbedButtonHandlerTimespec *timespec = new MenbedButtonHandlerTimespec();
    
    displayer = new MenbedDisplayer (display);
    navigator = new MenbedNavigator (rootMenu, displayer);
    buttonHandler = new MenbedButtonHandler (select, down, up, timespec, navigator);
    refresher = new MenbedRefresher (navigator);
}

Menbed::Menbed (PinName select, PinName down,
    MenbedMenu *rootMenu,
    MenbedDisplay *display)
{
    MenbedButtonHandlerTimespec *timespec = new MenbedButtonHandlerTimespec();
    
    displayer = new MenbedDisplayer (display);
    navigator = new MenbedNavigator (rootMenu, displayer);
    buttonHandler = new MenbedButtonHandler (select, down, timespec, navigator);
    refresher = new MenbedRefresher (navigator);
}

Menbed::Menbed(PinName select, PinName down, PinName up, PinName cancel, 
    MenbedButtonHandlerTimespec *timespec,
    MenbedMenu *rootMenu,
    MenbedDisplay *display)
{
    displayer = new MenbedDisplayer (display);
    navigator = new MenbedNavigator (rootMenu, displayer);
    buttonHandler = new MenbedButtonHandler (select, down, up, cancel, timespec, navigator);
    refresher = new MenbedRefresher (navigator);
}

Menbed::~Menbed()
{
    delete refresher;
    delete buttonHandler;
    delete navigator;
    delete displayer;
}