#ifndef _MENBEDMENUPARAM_H_
#define _MENBEDMENUPARAM_H_

class MenbedMenuParam {
public:
    // Copy of the initial value;
    float initVal;
    // Temporary copy of the parameter used to the hold the modified value
    // before it is committed.
    float tempVal;
    
    MenbedMenuParam (float (*initValFcn)(void), void (*finalValFcn)(float),
        bool liveUpdate, float min, float max,
        float inc);
        
    float getVal (void);
    void setVal (float v);
    bool liveUpdate (void) {return _liveUpdate;}
    float min (void) {return _min;}
    float max (void) {return _max;}
    float inc (void) {return _inc;}
            
protected:
    // Pointer to a function returning a float containing the current value of
    // the parameter.
    float (*initValFcn)(void);
    // Pointer to a function taking a float that is called when the parameter
    // value is modified.
    void (*finalValFcn)(float);
    // Boolean indicating whether the finalValFcn should be called each time
    // the user makes a change to the variable or whether it should only be
    // called once the user confirms the change.
    bool _liveUpdate;
    // Minimum allowable value.
    float _min;
    // Maximum allowable value.
    float _max;
    // Amount by which to increment/decrement the parameter with each presses of
    // the up/down button.
    float _inc;
};

#endif /* _MENBEDMENUPARAM_H_ */