#ifndef _MENBEDBUTTONHANDLER_H_
#define _MENBEDBUTTONHANDLER_H_

#include "mbed.h"
#include "menbedNavigator.h"
#include "menbedButtonHandlerTimespec.h"

class MenbedButtonHandler {
public:
    MenbedButtonHandler(PinName selectPin, PinName downPin, PinName upPin, PinName cancelPin,
        MenbedButtonHandlerTimespec *timespec, MenbedNavigator *navigator);
    MenbedButtonHandler(PinName selectPin, PinName downPin, PinName upPin,
        MenbedButtonHandlerTimespec *timespec, MenbedNavigator *navigator);
    MenbedButtonHandler(PinName selectPin, PinName downPin,
        MenbedButtonHandlerTimespec *timespec, MenbedNavigator *navigator);
                  
protected:
    DigitalIn *select, *down, *up, *cancel;
    MenbedButtonHandlerTimespec *timespec;
    MenbedNavigator *navigator;
    
    Ticker ticker;
    uint32_t tickerPeriod_us;
    uint32_t currentTime_us;
    
    int numButtons;
    
    uint32_t buttonPushedTime_us[4]; // Absolute time button first depressed
    bool buttonDebounced[4]; // Keep track of which buttons are debounced
    uint32_t buttonLastTypematicTime_us[4]; // Abs. time of last virtual push
    bool buttonAlreadyDepressed[4]; // Keep track of state b/t calls to tick()
    
    void init (void);
    void tick (void);
    bool isButtonDepressed (MenbedButtonEvent::ButtonName);
};

#endif /* _MENBEDBUTTONHANDLER_H_ */