#include "mbed.h"
#include "APDS9960.h"
#include <math.h>
#include "Puck.h"

DigitalOut mplay(P0_0);
DigitalOut mpause(P0_2);
DigitalOut mnext(P0_4);
DigitalOut mrev(P0_1);
DigitalOut mup(P0_3);
DigitalOut mdown(P0_5);

APDS9960    apds(P0_22, P0_20);                             // FIX THIS LINE

Puck* puck = &Puck::getPuck();

const UUID CUBE_SERVICE_UUID = stringToUUID("bftj cube       ");
const UUID DIRECTION_UUID = stringToUUID("bftj cube dirctn");

enum Direction {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    FRONT,
    BACK,
    UNDEFINED
};

Direction direction = UNDEFINED;
Direction new_direction = UNDEFINED;
void log_direction(Direction direction)                         // May be unnecessary.
{
    switch(direction) {
        case UP:
            LOG_INFO("Direction UP\n");
            mplay=1;
            break;
        case DOWN:
            LOG_INFO("Direction DOWN\n");
            mpause=1;
            break;
        case LEFT:
            LOG_INFO("Direction LEFT\n");
            mrev=1;
            break;
        case RIGHT:
            LOG_INFO("Direction RIGHT\n");
            mnext=1;
            break;
        case BACK:
            LOG_INFO("Direction BACK\n");
            mup=1;
            break;
        case FRONT:
            LOG_INFO("Direction FRONT\n");
            mdown=1;
            break;
        default:
            LOG_INFO("Direction UNSET\n");
            mplay=0;
            mpause=0;
            mnext=0;
            mrev=0;
            mup=0;
            mdown=0;
            break;
    }
}

void log_gesture(void)
{
    new_direction = UNDEFINED;
    if ( apds.isGestAvailable() ) {
        printf("Gesture is Available\n\r");
        switch ( apds.readGest() ) {
            case DIR_O:
                printf("OUT.\r\n");
                new_direction = UP;
                break;
            case DIR_I:
                printf("IN.\n\r");
                new_direction = DOWN;
                break;
            case DIR_W:
                printf("West.\n\r");
                new_direction = LEFT;
                break;
            case DIR_E:
                printf("East.\n\r");
                new_direction = RIGHT;
                break;
            case DIR_N:
                printf("North.\r\n");
                new_direction = FRONT;
                break;
            case DIR_S:
                printf("South.\n\r");
                new_direction = BACK;
                break;

            default:
                printf("Waiting on Gesture.\n\r");
        }
    }
    if (direction == new_direction) {
        return;
    }
    direction = new_direction;

    log_direction(direction);
    uint8_t directionAsInteger = direction;
    int length = 1;
    puck->updateCharacteristicValue(DIRECTION_UUID, &directionAsInteger, length);
}

int main()
{
    if(!apds.init()) {
        printf("Initialization ERROR.\n\r");
    } else {
        printf("Initialization Complete.\n\r");
    }

    if(apds.enGestSens(true)) {
        printf("Gesture Sensor Enabled\r\n");
    } else {
        printf("Gesture Sensor is not enabled.\r\n");
    }


    int characteristicValueLength = 1;
    puck->addCharacteristic(
        CUBE_SERVICE_UUID,
        DIRECTION_UUID,
        characteristicValueLength,
        GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

    puck->init(0xC1BE);


    Ticker ticker;
    ticker.attach(log_gesture, 0.2);
    LOG_INFO("Started listening to orientation changes.\n");

    while(puck->drive());
}