// LSM9DS90/uLCD Demo
// ECE 4180 Lab Code Template

#include "mbed.h"
#include "uLCD_4DGL.h"

// refresh time. set to 500 for part 2 and 50 for part 4
#define REFRESH_TIME_MS 500

InterruptIn lplay(p26);
InterruptIn lpause(p25);
InterruptIn lnext(p24);
InterruptIn lreverse(p23);
InterruptIn lvup(p22);
InterruptIn lvdown(p21);


// Verify that the pin assignments below match your breadboard
//LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);
//Serial pc(USBTX, USBRX);

uLCD_4DGL lcd(p9, p10, p11);

void playint()
{
	lcd.cls();
	lcd.set_sector_address(0x001D, 0x7801);
    lcd.display_image(0,0);
    wait(0.5);
}

void pauseint()
{
	lcd.cls();
	lcd.set_sector_address(0x001D, 0x7842);
    lcd.display_image(0,0);
    wait(0.5);
}

void nextint()
{
	lcd.cls();
	lcd.set_sector_address(0x001D, 0x7883);
    lcd.display_image(0,0);
    wait(0.5);
}

void revint()
{
	lcd.cls();
	lcd.set_sector_address(0x001D, 0x78C4);
    lcd.display_image(0,0);
    wait(0.5);
}

void vupint()
{
	lcd.cls();
	lcd.set_sector_address(0x001D, 0x7946);
    lcd.display_image(0,0);
    wait(0.5);
}

void vdownint()
{
	lcd.cls();
	lcd.set_sector_address(0x001D, 0x7905);
    lcd.display_image(0,0);
    wait(0.5);
}

int main()
{
    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();

    lcd.printf("Initializing...");

    lcd.cls();
    lcd.media_init();
    lplay.rise(&playint);
    lpause.rise(&pauseint);
    lnext.rise(&nextint);
    lreverse.rise(&revint);
    lvup.rise(&vupint);
    lvdown.rise(&vdownint);
    while(1) {
    	lcd.cls();
    	lcd.printf("Waiting for gesture");
    	wait(0.5);
    }
}
