#ifndef _SENSORBOARDS_H
#define _SENSORBOARDS_H
#include "mbed.h"

#define SENSOR_NUMBERS 0xA1
#define SENSORS_IDS 0xA2
#define SENSOR_READINGS 0xA3

struct Board
{
	uint8_t I2CAddress;
	uint8_t sensorIDs[8];
	uint8_t numberOfSensors;
};

class SensorBoards
{
public:
	uint8_t sensorBoardScanner();
	uint8_t sensorIDScanner();
	uint8_t getSensorNumbers(uint8_t address);
	uint8_t getSensorIDs(uint8_t address, uint8_t *IDBuffer);
	void getSensorReadings(uint8_t address, uint8_t ID, uint8_t* IDMeasure);
private:
	Board boards[1];
};

#endif