

#include "mbed.h"
#include "SHT30DISB.h"


SHT30DISB::SHT30DISB (PinName sda, PinName scl) : _i2c(sda, scl) {
    init();
}
SHT30DISB::SHT30DISB (I2C& p_i2c) : _i2c(p_i2c) {
    init();
}

void SHT30DISB::init(void)
{
    _i2c.frequency(400000);
    buf[0]=0x2c;
    buf[1]=0x06;
    data_buf[6]= _i2c.write(SHT30DISB_ADDR,buf,2);
    buf[0]=0x30;
    buf[1]=0x66;
    data_buf[7]= _i2c.write(SHT30DISB_ADDR,buf,2);
    
//    put(0x2C,0x06); //Config measurement
//    put(0x30, 0x66); //Heat off
    
}
void SHT30DISB::put(unsigned char a, unsigned char b)
{
    buf[0]=a;
    buf[1]=b;
    _i2c.write(SHT30DISB_ADDR, buf, 2);
}


void SHT30DISB::get(unsigned char a)
{
    buf[0] = a;
    _i2c.write(SHT30DISB_ADDR, buf, 1, true); // no stop, repeated
    _i2c.read(SHT30DISB_ADDR, buf, 1);

}


void SHT30DISB::readSensor()
{
//    data_buf[0]=_i2c.read(SHT30DISB_ADDR, SHT30DISB_DATA, 6, true); // no stop, repeated
    buf[0]=0x2c;
    buf[1]=0x06;
   data_buf[0]=_i2c.write(0x8A, buf,2);
    wait(.1);
    data_buf[1]=_i2c.read(0x8A, SHT30DISB_DATA, 6, false); 

}


float SHT30DISB::cTemp(){
    readSensor();
    c_Temp = -45 + 175 * ((((SHT30DISB_DATA[0] * 256.0) + SHT30DISB_DATA[1])) / 65535.0);
    return c_Temp;    
}
        
float SHT30DISB::fTemp(){
    f_Temp = 32 + 1.8 * cTemp();
    return f_Temp;
}
    
float SHT30DISB::humidity(){
    humi = 100 * ((((SHT30DISB_DATA[3] * 256.0) + SHT30DISB_DATA[4])) / 65535.0);
    return humi;
}



