

#ifndef SHT30DISB_H_
#define SHT30DISB_H_

#define SHT30DISB_ADDR 0x8A
#define SHT30DISB_CLKENHI 0x2C06
#define SHT30DISB_HEATON 0x306D
#define SHT30DISB_HEATOFF 0x3066


#include "mbed.h"
#include "typedef.h"

class SHT30DISB{
public:
    SHT30DISB (PinName sda, PinName scl);
    SHT30DISB (I2C& p_i2c);

    void put(unsigned char a, unsigned char b);
    void get(unsigned char a);
    void readSensor();
    void init();
    float cTemp();
    float fTemp();
    float humidity();

    char SHT30DISB_DATA[6];
    char data_buf[8];
    
    
protected:
    
    I2C _i2c;

    char buf[2];

    float c_Temp;
    float f_Temp;
    float humi;

};

#endif /* SHT30DISB_H_ */



