/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    ( C )2014 Semtech

Description: Tx Continuous Wave implementation

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainers: Miguel Luis, Gregory Cristian and Nicolas Huguenin
*/
#include "mbed.h"
#include "sx1276-hal.h"
#include "debug.h"

/* Set this flag to '1' to test the HF max output power or '0' to the the LF max output power */
#define TEST_HF_OUTPUT                              1
#define TEST_LF_OUTPUT = !TEST_HF_OUTPUT

#define LORA_BANDWIDTH                              0         // [0: 125 kHz,
                                                              //  1: 250 kHz,
                                                              //  2: 500 kHz,
                                                              //  3: Reserved]
#define LORA_SPREADING_FACTOR                       9         // [SF7..SF12]
#define LORA_CODINGRATE                             1         // [1: 4/5,
                                                              //  2: 4/6,
                                                              //  3: 4/7,
                                                              //  4: 4/8]
#define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
#define LORA_SYMBOL_TIMEOUT                         5         // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                  false
#define LORA_FHSS_ENABLED                           false  
#define LORA_NB_SYMB_HOP                            4         // Symbols    
#define LORA_IQ_INVERSION_ON                        false
#define LORA_CRC_ENABLED                            true


SX1276MB1xAS Radio( NULL, NULL, NULL, NULL, NULL, NULL, NULL );

/**
 * Main application entry point.
 */
int main( void )
{
    uint8_t TxOuputPower = 0;

    debug("\n\r\n\r     SX1276 Continuous Wave at full power Demo Application \n\r");
        
#if defined TARGET_NUCLEO_L152RE
    debug("         > Nucleo-L152RE Platform <\r\n" );
#elif defined TARGET_KL25Z
    debug("         > KL25Z Platform <\r\n" );
#elif defined TARGET_LPC11U6X
    debug("         > LPC11U6X Platform <\r\n" );
#else
    debug("         > Untested Platform <\r\n" );
#endif

    /**********************************************/
    /*                  WARNING                   */
    /* The below settings can damage the chipset  */
    /* if wrongly used. DO NOT CHANGE THE VALUES! */
    /*                                            */
    /**********************************************/
    
#if( TEST_HF_OUTPUT == 1 )

    if( Radio.DetectBoardType( ) == SX1276MB1LAS ) // 
    {
        debug("\r\n     TEST_HF_OUTPUT on SX1276MB1LAS: 20 dBm at 915 MHz \r\n" );
        Radio.SetChannel( 915000000 );
        TxOuputPower = 14;
        Radio.Write( 0x01, 0x80 );
        Radio.Write( 0x44, 0x7B );
        Radio.Write( 0x3D, 0xA1 );
        Radio.Write( 0x36, 0x01 );
        Radio.Write( 0x1e, 0x08 );
        Radio.Write( 0x45, 0xDF );
        Radio.Write( 0x46, 0x03 );
        Radio.Write( 0x4D, 0x87 );
        Radio.Write( 0x52, 0x60 );
        
        
    }
    else
    {   // SX1276MB1MAS
        debug("\r\n     TEST_HF_OUTPUT on SX1276MB1MAS: 14 dBm at 868 MHz \r\n" );
        Radio.SetChannel( 880030000 );
        TxOuputPower = 20;
        Radio.Write( 0x01, 0x88 );
        Radio.Write( 0x3D, 0xA1 );
        Radio.Write( 0x36, 0x01 );
        Radio.Write( 0x1e, 0x08 );
    }
    
#else //if( TEST_LF_OUTPUT == 1 )

    debug("\r\n     TEST_LF_OUTPUT on SX1276MB1xAS: 14 dBm at 434 MHz \r\n" );
    Radio.SetChannel( 433000000 );
    TxOuputPower = 14;
    Radio.Write( 0x01, 0x88 );
    Radio.Write( 0x3D, 0xA1 );
    Radio.Write( 0x36, 0x01 );
    Radio.Write( 0x1e, 0x08 );

#endif

    Radio.SetTxConfig( MODEM_LORA, TxOuputPower, 0, LORA_BANDWIDTH,
                        LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                        LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                        LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP, 
                        LORA_IQ_INVERSION_ON, 3000000 );
    
    // Sets the radio in Tx mode
    Radio.Send( NULL, 0 );

    debug( "Start main loop: \r\n" );
    // Blink LEDs just to show some activity
    while( 1 )
    {
        debug( "Continuous Wave activated... \r\n" );
        wait_ms( 200 );
    }
}

