/**
 ******************************************************************************
 * @file    main.cpp
 * @author  Davide Aliprandi, STMicroelectronics
 * @version V1.0.0
 * @date    October 28th, 2016
 * @brief   mbed test application for the STMicroelectronics X-NUCLEO-CCA02M1
 *          MEMS Microphones Expansion Board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2016 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"


#if DEVICE_I2S

/* Expansion Board specific header files. */
#include "XNucleoCCA02M1.h"


/* Variables -----------------------------------------------------------------*/

/*
 * Initialization parameters.
 * Note: put a jumper to connect PB_5 and PB_13 on the MORPHO connector when
 *       running a mono configuration.
 */
XNucleoCCA02M1_init_t init =
{
	44100,  /* Default Sampling Frequency [Hz]. */
    2       /* Default number of channels. */
};


/* Functions -----------------------------------------------------------------*/

/**
 * @brief  Entry point function of mbedOS.
 * @param  None
 * @retval None
 */
int main(void)
{
    /*----- Initialization. -----*/

    /* Initializing MEMS Microphones Expansion Board on the I2S1 interface. */
    XNucleoCCA02M1 *microphones = new XNucleoCCA02M1(PB_15, PB_13);
    if (microphones->init(&init) != COMPONENT_OK)
    {
        error("Initialization of the MEMS Microphones Expansion Board failed.\r\n");
        exit(EXIT_FAILURE);
    }

    /* Enabling transmission via USB. */
    microphones->enable_usb();

    /* Printing to the console. */
    printf("MEMS Microphones Application Example\r\n\n");


    /*----- Recording. -----*/

    /* Printing to the console. */
    printf("--> Recording...\r\n");
    microphones->record();

    /* Dispatching forever the I2S queue. */
    I2S::i2s_bh_queue.dispatch_forever();
}

#else // DEVICE_I2S

int main(void)
{
    printf("The target does not support I2S API.\r\n");
}

#endif // DEVICE_I2S
