// BaseUsbHostLib.cpp 2014/4/22
#include "USBHost.h"
//#define DEBUG
#include "BaseUsbHostDebug.h"
#define TEST
#include "BaseUsbHostTest.h"

//#define DBG_USE_POSIX_MEMALIGN

#ifdef DBG_USE_POSIX_MEMALIGN
void* usb_ram_malloc(size_t size, int aligment)
{
    TEST_ASSERT(aligment >= 4);
    TEST_ASSERT(!(aligment & 3));
    void* p;
    if (posix_memalign(&p, aligment, size) == 0) {
        return p;
    }
    return NULL;
}

void usb_ram_free(void* p)
{
    free(p);
}
#else

#define CHUNK_SIZE 64

#if defined(TARGET_LPC1768)
#define USB_RAM_BASE 0x2007C000
#define USB_RAM_SIZE 0x4000
#define BLOCK_COUNT (USB_RAM_SIZE/CHUNK_SIZE)
#elif defined(TARGET_LPC4088)
#define USB_RAM_BASE 0x20000000
#define USB_RAM_SIZE 0x4000
#define BLOCK_COUNT (USB_RAM_SIZE/CHUNK_SIZE)
#else
#error "target error"
#endif

static uint8_t* ram = NULL;
static uint8_t* map;

static void usb_ram_init()
{
    USB_INFO("USB_RAM: 0x%p(%d)", USB_RAM_BASE, USB_RAM_SIZE);
    ram = (uint8_t*)USB_RAM_BASE;
    TEST_ASSERT((int)ram%256 == 0);
    map = (uint8_t*)malloc(BLOCK_COUNT);
    TEST_ASSERT(map);
    memset(map, 0, BLOCK_COUNT);
}

// first fit malloc
void* usb_ram_malloc(size_t size, int aligment)
{
    TEST_ASSERT(aligment >= 4);
    TEST_ASSERT(!(aligment & 3));
    if (ram == NULL) {
        usb_ram_init();
    }
    int needs = (size+CHUNK_SIZE-1)/CHUNK_SIZE;
    void* p = NULL;
    for(int idx = 0; idx < BLOCK_COUNT;) {
        bool found = true;
        for(int i = 0; i < needs; i++) {
            int block = map[idx + i];
            if (block != 0) {
                idx += block;
                found = false;
                break;
            }
        }
        if (!found) {
            continue;
        }
        p = ram+idx*CHUNK_SIZE;
        if ((int)p % aligment) {
            idx++;
            continue;
        }
        TEST_ASSERT((idx + needs) <= BLOCK_COUNT);
        for(int i = 0; i < needs; i++) {
            map[idx + i] = needs - i;
        }
        break;
    }
    TEST_ASSERT(p);
    return p;
}

void usb_ram_free(void* p)
{
    TEST_ASSERT(p >= ram);
    TEST_ASSERT(p < (ram+CHUNK_SIZE*BLOCK_COUNT));
    int idx = ((int)p-(int)ram)/CHUNK_SIZE;
    int block = map[idx];
    TEST_ASSERT(block >= 1);
    for(int i =0; i < block; i++) {
        map[idx + i] = 0;
    }
}

#endif // DBG_USE_POSIX_MEMALIGN


