// BaseUsbHostDebug.h 2014/4/22
#pragma once

#ifdef USB_DEBUG
//#define USB_DBG(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);} while(0);
#define USB_DBG_IF(C, ...) if(C){fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);}else{}
#define USB_DBG_ED_IF(C,A) if(C){fprintf(stderr,"[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);print_ed(stderr,A);}else{}
#define USB_DBG_ED(A) fprintf(stderr,"[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);print_ed(stderr,A);
#else
//#define USB_DBG(...)  while(0);
#define USB_DBG_IF(...)  while(0);
#define USB_DBG_ED_IF(C,A) while(0)
#define USB_DBG_ED(A) while(0)
#endif

#ifdef DEBUG
#define DBG(...) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);fprintf(stderr,__VA_ARGS__);} while(0);
#define DBG_PRINTF(...) do{fprintf(stderr,__VA_ARGS__);}while(0);
#define DBG_TD(A) do{fprintf(stderr,"[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);print_td(stderr,A);}while(0);
#define DBG_ED(A) do{fprintf(stderr,"[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);print_ed(stderr,A);}while(0);
#define DBG_ITD(A) do{fprintf(stderr,"[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);print_itd(stderr,A);}while(0);
#define DBG_IED(A) do{fprintf(stderr,"[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);print_ied(stderr,A);}while(0);
#define DBG_BYTES(A,B,C) do{fprintf(stderr,"[%s@%d] ",__PRETTY_FUNCTION__,__LINE__);print_bytes(stderr,A,B,C);}while(0);
#define DBG_HEX(A,B) do{fprintf(stderr,"[%s@%d]\n",__PRETTY_FUNCTION__,__LINE__);print_hex(stderr,A,B);}while(0);
#define DBG_OHCI(A) do{fprintf(stderr,"[%s@%d] %s: %08X\n",__PRETTY_FUNCTION__,__LINE__,#A,A);}while(0);
#else //DEBUG
#define DBG(...)  while(0);
#define DBG_PRINTF(...) while(0);
#define DBG_TD(A) while(0);
#define DBG_ED(A) while(0);
#define DBG_ITD(A) while(0);
#define DBG_IED(A) while(0);
#define DBG_BYTES(A,B,C) while(0);
#define DBG_HEX(A,B) while(0);
#define DBG_OHCI(A) while(0);
#endif //DEBUG

void print_td(FILE* stream, HCTD* td);
void print_ed(FILE* stream, HCED* ed);
void print_itd(FILE* stream, HCITD* itd);
void print_ied(FILE* stream, HCED* ed);
void print_bytes(FILE* stream, char* s, uint8_t* buf, int len);
void print_hex(FILE* stream, uint8_t* p, int len);


