#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "LM75B.h"
#include "C12832_lcd.h"
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

C12832_LCD lcd;
LM75B tmp(p28,p27);

int main()
{
    
char t[100];
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    lcd.printf("IP Address is %s\n\r", eth.getIPAddress());

    wait(2.0);

    Websocket ws("ws://sockets.mbed.org:443/ws/rs/wo");
    ws.connect();
    wait(2.0);
    
    ws.send("Welcome to RS Components IOT demo: message broadcasting");
    wait(1.0);
    
    while (1) {
    
    float tp=tmp.read();
    sprintf(t, "[RS Components]Current Room Temperature :%.2f", (float)tp);
    ws.send(t);

        for(float i = 0; i < 1.0 ; i += 0.01) {
            float p = (((tmp.read()/100)-0.34)*500);// 0.34 is the offset of the Temp.of 34 oC and 500 is the scale of change in color

            r = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
            g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
            b = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;
            wait (0.005);

            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Current Room Temp. :%.2foC",tmp.read());
            wait(0.1);
        }
    }
}