#include "mbed.h"

#include "USBMIDI.h"

// GM standard drum map, see: http://commons.wikimedia.org/wiki/File:GMStandardDrumMap.gif
#define C1      36  // bass drum
#define Cis1    37  // side stick
#define D1      38  // acoustic snare
#define Dis1    39  // hand clap
#define E1      40  // electric snare
#define F1      41  // low floor tom
#define Fis1    42  // closed hi-hat
#define G1      43  // high floor tom
#define Gis1    44  // pedal hi-hat
#define A1      45  // low tom
#define Ais1    46  // open hi-hat
#define B1      47  // low-mid tom
#define C2      48  // hi-mid tom
#define Cis2    49  // crash cymbal
#define D2      50  // hi tom
#define Dis2    51  // ride cymbal
#define E2      52  // chinese cymbal
#define F2      53  // ride bell
#define Fis2    54  // tamburine
#define G2      55  // splash cymbal
#define Gis2    56  // cowbell
#define A2      57  // crash cymbal 2
#define Ais2    58  // vibraslap
#define B2      59  // ride cymbal 2
#define C3      60
#define Cis3    61
#define D3      62
#define Dis3    63
#define E3      64
#define F3      65
#define Fis3    66
#define G3      67
#define Gis3    68
#define A3      69
#define Ais3    70
#define B3      71
#define C4      72
#define Cis4    73
#define D4      74
#define Dis4    75
#define E4      76
#define F4      77
#define Fis4    78
#define G4      79
#define Gis4    80
#define A4      81
#define Ais4    82
#define B4      83

#define HIHAT_CLOSED Fis1
#define HIHAT_OPEN   Ais1
#define HIHAT_PEDAL  Gis1
#define BASEDRUM     C1
#define SNARE        E1

#define TEMPO        0.2

#define FULL         127
#define NORMAL       100
#define BLUENOTE     70 


USBMIDI midi;
DigitalOut myled(LED1);

void beat_1() {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
    midi.write( MIDIMessage::NoteOn( BASEDRUM    , NORMAL ) );
}

void beat_1_E () {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
}

void beat_1_AND () {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
    midi.write( MIDIMessage::NoteOn( BASEDRUM    , NORMAL ) );    
}
    
void beat_1_A () {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
}

void beat_2() {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
    midi.write( MIDIMessage::NoteOn( SNARE       , FULL ) );
}

void beat_2_E () {
    midi.write( MIDIMessage::NoteOn( HIHAT_OPEN  , BLUENOTE ) );
}

void beat_2_AND () {
    midi.write( MIDIMessage::NoteOn( HIHAT_OPEN  , BLUENOTE ) );
    midi.write( MIDIMessage::NoteOn( HIHAT_PEDAL , NORMAL ) );
    midi.write( MIDIMessage::NoteOff( HIHAT_OPEN , BLUENOTE ) );            
}
    
void beat_2_A () {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
    midi.write( MIDIMessage::NoteOn( SNARE       , BLUENOTE ) );
}

void beat_3() {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
}

void beat_3_E () {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
    midi.write( MIDIMessage::NoteOn( SNARE       , BLUENOTE ) );
}

void beat_3_AND () {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
    midi.write( MIDIMessage::NoteOn( BASEDRUM    , NORMAL ) );
}
    
void beat_3_A () {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
    midi.write( MIDIMessage::NoteOn( SNARE       , BLUENOTE ) );
}

void beat_4() {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL) );
    midi.write( MIDIMessage::NoteOn( SNARE       , FULL ) );
}

void beat_4_E () {
    midi.write( MIDIMessage::NoteOn( HIHAT_OPEN  , BLUENOTE ) );
    midi.write( MIDIMessage::NoteOn( BASEDRUM    , NORMAL ) );
}

void beat_4_AND () {
    midi.write( MIDIMessage::NoteOn( HIHAT_OPEN  , BLUENOTE ) );
    midi.write( MIDIMessage::NoteOn( HIHAT_PEDAL , NORMAL ) );
    midi.write( MIDIMessage::NoteOff( HIHAT_OPEN , BLUENOTE ) );   }
    
void beat_4_A () {
    midi.write( MIDIMessage::NoteOn( HIHAT_CLOSED, NORMAL ) );
    midi.write( MIDIMessage::NoteOn( SNARE       , BLUENOTE ) );
}





int main() {
    while(1) {
        
        myled = 1;
        beat_1();
        wait( TEMPO );
        myled = 0;
        beat_1_E();
        wait( TEMPO );
        myled = 1;
        beat_1_AND();
        wait( TEMPO );
        myled = 0;
        beat_1_A();
        wait( TEMPO );

        myled = 1;
        beat_2();
        wait( TEMPO );
        myled = 0;
        beat_2_E();
        wait( TEMPO );
        myled = 1;
        beat_2_AND();
        wait( TEMPO );
        myled = 0;
        beat_2_A();
        wait( TEMPO );

        myled = 1;
        beat_3();
        wait( TEMPO );
        myled = 0;
        beat_3_E();
        wait( TEMPO );
        myled = 1;
        beat_3_AND();
        wait( TEMPO );
        myled = 0;
        beat_3_A();
        wait( TEMPO );

        myled = 1;
        beat_4();
        wait( TEMPO );
        myled = 0;
        beat_4_E();
        wait( TEMPO );
        myled = 1;
        beat_4_AND();
        wait( TEMPO );
        myled = 0;
        beat_4_A();
        wait( TEMPO );
    }
}