
#ifndef TOUCHPAD_H_
#define TOUCHPAD_H_

#include "mbed.h"
#include "cr_dsplib.h"

/* Debido a la linealidad del touchscreen, la posicion Y va de 0 a 6 y la posicion X va de 0 a 5 */
/* Esto se debe corregir en futuras revisiones mediante una calibracion del touchscreen */

/* Configuracion del touchpad */
/*
 *  AD0.4                 OPEN-DRAIN              OPEN-DRAIN        AD0.5
 *  P1[30]                   P2[0]                   P2[1]          P1[31]
 *    |                        |                       |              |
 *    |           _____________|______________         |              |
 *    |          |                            |        |              |
 *    |          |                            |        |              |
 *    |__________|         Touchpad           |________|              |
 *               |                            |                       |
 *               |                            |                       |
 *               |____________________________|                       |
 *                             |                                      |
 *                             |______________________________________|
 */

/************************************DEFINICIONES DE TIPOS********************************************/
/*Estructura de la posicion actual del dedo*/
typedef struct
{
	uint32_t pos_x;	/*Coordenada X*/
	uint32_t pos_y; /*Coordenada Y*/

} touchpad_position;

/************************************DEFINICIONES DE FUNCIONES*****************************************/

touchpad_position get_position(void); /*Funcion para obtencion de coordendas actuales del dedo en el touchpad*/

void init_touchpad(void);

#endif /* TOUCHPAD_H_ */
