
#include "timer.h"
#include "leds_mbed.h"

void init_timer(void)
{
    /* Configuro el MAT0.0 para que genere el clock de muestreo de
     * tanto el DAC como el ADC (mediante el manejo de los DMA requests) */

    LPC_SC->PCONP |= 1 << 1;    /* Enciendo modulo Timer 0 */

    LPC_SC->PCLKSEL0 &= ~(0x03 << 2);    /* Clock del Timer 0: */
                                        /* 00 = CLCK/4    */
                                        /* 01 = CLCK      */
                                        /* 10 = CLCK/2    */
                                        /* 11 = CLCK/8    */
                                        /* Actualmente configurado en CLCK/4 */

    /* Interrupt register */
    LPC_TIM0->IR = 0x0;    /* Limpio cualquier interrupcion previa */

    /* Timer Control Register */
    LPC_TIM0->TCR = 0x2; /* Reseteo contadores y deshabilito el timer */

    /* Count Control Register */
    LPC_TIM0->CTCR = 0x0; /* Modo timer (NO contador!) */

    /* Preescale Register */
    LPC_TIM0->PR = 0x1; /* Es la cantidad de clocks que deben pasar para incrementar el Timer 0 */
                        /* Si PR=0, el timer incrementa en cada CLK. Si PR=1, el timer incrementa cada dos CLK, etc. */

    /* Match Register 0 */
    LPC_TIM0->MR0 = SAMPLING_DIV; /* El valor del Match Register se comparar continuamente con el valor del Timer.
                                * Cuando sean iguales se producira un DMA request desde el ADC y hacia el DAC.
                                * Es por eso que este valor determina la frecuencia de muestreo de ambos.
                                * Para calcular el valor hay que hacer lo siguiente: Suponiendo una frecuencia
                                * de muestreo deseada de Fx, y un clock (preescaler igual a cero) de CLK/8
                                * el valor de MR0 necesario ser = (CLK/8)/Fx */
                               /* Con 283 tenemos una frecuencia de muestreo de ~44.1KHz */
                               /* Con 125 tenemos una frecuencia de muestreo de 100KHz */

    /* Match Control Register. */
    LPC_TIM0->MCR = (0 << 0) | /* Interrupcion por Match 0 deshabilitada */
                    (1 << 1) | /* Resetear el timer cuando haya un match 0 */
                    (0 << 2);  /* No parar el timer cuando hay un match 0 */

    /* Inicio el Timer 0 */
    LPC_TIM0->TCR = 0x1;
    
}


