/* Rutina util para debuggear. Solo sirve para la placa MBED */

#include "leds_mbed.h"

void show_number_on_leds(uint32_t number)
{
    DigitalOut led_1(LED1);
    DigitalOut led_2(LED2);
    DigitalOut led_3(LED3);
    DigitalOut led_4(LED4);
    
    /* De led mas significativo a menos significativo se lee: LED4 LED3 LED2 LED1 */

    switch(number)
    {
        case 0: led_4 = led_3 = led_2 = led_1 = 0;
                break;
        case 1: led_4 = led_3 = led_2 = 0;
                led_1 = 1;
                break;
        case 2: led_4 = led_3 = led_1 = 0;
                led_2 = 1;
                break;
        case 3: led_4 = led_3 = 0;
                led_2 = led_1 = 1;
                break;
        case 4: led_4 = led_2 = led_1 = 0;
                led_3 = 1;
                break;
        case 5: led_4 = led_2 = 0;
                led_3 = led_1 = 1;
                break;
        case 6: led_4 = led_1 = 0;
                led_3 = led_2 = 1;
                break;
        case 7: led_4 = 0;
                led_3 = led_2 = led_1 = 1;
                break;
        case 8: led_3 = led_2 = led_1 = 0;
                led_4 = 1;
                break;
        case 9: led_3 = led_2 = 0;
                led_4 = led_1 = 1;
                break;
        case 10: led_3 = led_1 = 0;
                 led_4 = led_2 = 1;
                 break;
        case 11: led_3 = 0;
                 led_4 = led_2 = led_1 = 1;
                 break;
        case 12: led_2 = led_1 = 0;
                 led_4 = led_3 = 1;
                 break;
        case 13: led_2 = 0;
                 led_4 = led_3 = led_1 = 1;
                 break;
        case 14: led_1 = 0;
                 led_4 = led_3 = led_2 = 1;
                 break;
        case 15: led_4 = led_3 = led_2 = led_1 = 1;
                 break;
        default: led_4 = led_3 = led_2 = led_1 = 1;
                 break;
    }
}
