
#ifndef CONFIG_H_
#define CONFIG_H_

/********************************CONFIGURACION**********************************/

#define BLOCKSIZE 1917 /* Tama&#65533;o del bloque (en words) a procesar */

#define COEFF_AMOUNT    256       /* Cantidad de coeficientes maxima del (o de los) filtros. */
                               /* Este valor determina el largo de los buffers para procesamiento */

/* Requisitos impuestos por el algoritmo de filtrado:
 * {(COEFF_AMOUNT-1)+BLOCKSIZE} debe ser multiplo de 4.
 * COEFF_AMOUNT debe ser tambien multiplo de 4.
 * COEFF_AMOUNT < {(COEFF_AMOUNT-1)+BLOCKSIZE}
 * Ejemplo: COEFF_AMOUNT=100 y BLOCKSIZE=101
 */

/* De acuerdo a nuestro filtrado antialiasing, con un muestreo de 57KHz vamos a tener una atenuacion
 * de -63dB del aliasing que se mete en la banda de audio (0-22KHz).
 */

#define    SAMPLING_DIV    195   /* Este valor fija la frecuencia de muestreo tanto del ADC como del DAC.
                               La cuenta para saber la frecuencia resultante de muestreo es la siguiente:
                               FSAMPLING = 100 MHz / (8 * SAMPLING_DIV).
                               Con 105 tenemos una frecuencia de muestreo de 120KHz
                               Con 156 tenemos una frecuencia de muestreo de 80KHz
                               Con 283 tenemos una frecuencia de muestreo de ~44.1KHz
                               Con 219 tenemos una frecuencia de muestreo de ~57KHz
                               Con 125 tenemos una frecuencia de muestreo de 100KHz
                               Con 12500 tenemos una frecuencia de 1KHz (para debug)
                               Con 125000 tenemos una frecuencia de 100Hz (para debug)
                               Con 1250000 tenemos una frecuencia de 10Hz (para debug)*/

/* En realidad, la frecuencia maxima de muestreo del ADC es de "192307,69230769230769230769230769 Hz"
 * porque la frecuencia de trabajo del mismo es de 12.5MHz y la conversion se produce cada 65 clocks.
 * Entonces, para que el submuestreo que realiza el DMA sea "correcto" la frecuencia con la que el DMA
 * toma los datos deberia ser un submultiplo de la del muestreo maximo del ADC
 * Considero una frecuencia exactamente 3 veces menor => "64102,564102564102564102564102564 Hz"
 * Entonces el SAMPLING_DIV deber&#65533;a ser de exactamente 195.
 */

#endif /* CONFIG_H_ */
