
#include "adc_dac.h"

void initDAC(void)
{
    LPC_PINCON->PINSEL1 |= (0x2 << 20);            /* Salida del DAC por pin numero P0.26 (AOUT)*/
                                                /* (Unico pin posible para esta funcion) */
    LPC_PINCON->PINMODE1 |= (0x2 << 20);        /* Deshabilito R de pull-up y R de pull-down */

    LPC_SC->PCLKSEL0 |= (0x3 << 22);            /* Clock del DAC: */
                                                /* 00 = CLCK/4    */
                                                /* 01 = CLCK      */
                                                /* 10 = CLCK/2    */
                                                /* 11 = CLCK/8    */

    LPC_DAC->DACCTRL = 0x00;     /* Desabilitar contador y DMA requests */

}

void initADC(void)
{
    LPC_SC->PCONP |= (1 << 12);    /* Enciendo modulo ADC */

    LPC_PINCON->PINSEL1 |= (0x1 << 14);            /* Salida del ADC por pin numero P0.23 (AD0.0) */

    LPC_PINCON->PINMODE1 |= (0x2 << 14);        /* Deshabilito R de pull-up y R de pull-down */

    LPC_SC->PCLKSEL0 |= (0x3 << 24);            /* Clock del ADC: */
                                                /* 00 = CLCK/4    */
                                                /* 01 = CLCK      */
                                                /* 10 = CLCK/2    */
                                                /* 11 = CLCK/8    */

    LPC_ADC->ADCR = (0x01 << 0)  | /* Selecciono el canal cero del ADC */
                    (0x00 << 8)  | /* Minimo clk_div. Recordar que este es el clock de coversion del ADC. No el tiempo entre muestras. El maximo admisible es 13MHz. */
                    (0x00 << 24);  /* Configuracion de START: como trabaja en modo BURST el start debe quedar en 0 */

    LPC_ADC->ADINTEN = 0x00; /* Todas las interrupciones DESACTIVADAS */

    /* Finalmente, inicio el ADC*/
    LPC_ADC->ADCR |= (0x1 << 21); /* Inicio ADC */
    LPC_ADC->ADCR |= (0x1 << 16); /* Inicio Modo Burst (conversion continua) */

}
