
/* Esta rutina de touchpad esta pensada especificamente para la aplicacion del KaossPad */
/* Si se quisiera portar a otro proyecto se deber� agregar una configuracion inicial del ADC */
/* As� como esta presupone que el ADC ya est� corriendo (modo BURST) */

#include "touchpad.h"

/* Configuracion del touchpad */
/*
 *  AD0.4                 OPEN-DRAIN              OPEN-DRAIN        AD0.5
 *  P1[30]                   P2[0]                   P2[1]          P1[31]
 *    |                        |                       |              |
 *    |           _____________|______________         |              |
 *    |          |                            |        |              |
 *    |          |                            |        |              |
 *    |__________|         Touchpad           |________|              |
 *               |                            |                       |
 *               |                            |                       |
 *               |____________________________|                       |
 *                             |                                      |
 *                             |______________________________________|
 */

void init_touchpad() {
    /* P2[0] y P2[1] se configuran como GPIO */
    LPC_PINCON->PINSEL4 &= ~(((unsigned int)0x3 << 0) | ((unsigned int)0x3 << 2));

    /*Deshabilito todas las R de pullup y pulldown (de P2[0], P2[1], P1[30] y P1[31])*/
    LPC_PINCON->PINMODE4 |= ((unsigned int)0x2 << 0) | ((unsigned int)0x2 << 2);
    LPC_PINCON->PINMODE3 |= ((unsigned int)0x2 << 28) | ((unsigned int)0x2 << 30);

    /* P2[0] y P2[1] se configuran como salidas */
    LPC_GPIO2->FIODIR |= ((unsigned int)0x1 << 0) | ((unsigned int)0x1 << 1);

    /* P2[0] y P2[1] se configuran como Open-Drain */
    LPC_PINCON->PINMODE_OD2 |= ((unsigned int)0x1 << 0) | ((unsigned int)0x1 << 1);

    /* Los pines P1[31] y P1[30] funcionaran tanto como ADC como GPIO
     * y por eso no se configuran inicialmente */
}

touchpad_position get_position(void) {
    touchpad_position positions;
    int i;

    /* Paro Modo Burst y desactivo canal AD0.0 (del audio) */
    LPC_ADC->ADCR &= ~(((unsigned int)0x1 << 16) | ((unsigned int)0x1 << 0));

    /* Configuro el touchpad para que me indique la posicion de X */

    LPC_PINCON->PINSEL3 |= ((unsigned int)0x3 << 30);  /* P1[31] -> AD0.5 */
    LPC_PINCON->PINSEL3 &= ~((unsigned int)0x3 << 28); /* P1[30] -> GPIO */
    LPC_GPIO1->FIODIR |= ((unsigned int)0x1 << 30); /* P1[30] es una salida */

    LPC_GPIO2->FIOCLR |= ((unsigned int)0x1 << 1);    /* Pongo en 0 el pin P2[1] */
    LPC_GPIO2->FIOSET |= ((unsigned int)0x1 << 0);    /* Pongo en 1 el pin P2[0] */
    LPC_GPIO1->FIOSET |= ((unsigned int)0x1 << 20);    /* Pongo en 1 el pin P1[30] */

    /* Delay de 1uS aprox. para que se estabilizen las lineas */
    for (i = 0; i < 100; i++);

    /* Activo canal AD0.5 (coordenada X) */
    LPC_ADC->ADCR |= ((unsigned int)0x1 << 5);

    /* Comienzo la conversion */
    LPC_ADC->ADCR |= ((unsigned int)0x1 << 24);

    /* Espero a que se complete la conversion */
    while ( (LPC_ADC->ADDR5 & 0x80000000) == 0x0 ) {
    }

    /* Almaceno la posicion X */
    positions.pos_x = ((LPC_ADC->ADDR5 & ((unsigned int)0x7 << 12)) >> 12 );

    /* Desactivo canal AD0.5 (coordenada X) */
    LPC_ADC->ADCR &= ~((unsigned int)0x1 << 5);

    /* Configuro el touchpad para que me indique la posicion de Y */

    LPC_PINCON->PINSEL3 &= ~((unsigned int)0x3 << 30);  /* P1[31] -> GPIO */
    LPC_PINCON->PINSEL3 |= ((unsigned int)0x3 << 28);   /* P1[30] -> AD0.4 */
    LPC_GPIO1->FIODIR |= ((unsigned int)0x1 << 31); /* P1[31] es una salida */

    LPC_GPIO2->FIOSET |= ((unsigned int)0x1 << 1);    /* Pongo en 1 el pin P2[1] */
    LPC_GPIO2->FIOCLR |= ((unsigned int)0x1 << 0);    /* Pongo en 0 el pin P2[0] */
    LPC_GPIO1->FIOSET |= ((unsigned int)0x1 << 31);    /* Pongo en 1 el pin P1[31] */

    /* Delay de 1uS aprox. para que se estabilizen las lineas */
    for (i = 0; i < 100; i++);

    /* Activo canal AD0.4 (coordenada Y) */
    LPC_ADC->ADCR |= ((unsigned int)0x1 << 4);

    /* Comienzo la conversion */
    LPC_ADC->ADCR |= ((unsigned int)0x1 << 24);

    /* Espero a que se complete la conversion */
    while ( (LPC_ADC->ADDR4 & (unsigned int)0x80000000) == (unsigned int)0x0 ) {
    }

    /* Almaceno la posicion Y */
    positions.pos_y = (((LPC_ADC->ADDR4) & ((unsigned int)0xF << 12)) >> 12 );

    /* Desactivo canal AD0.4 (coordenada Y) */
    LPC_ADC->ADCR &= ~((unsigned int)0x1 << 4);

    /* Restauro configuracion del ADC */

    /* Activo canal AD0.0 (del audio) */
    LPC_ADC->ADCR |= ((unsigned int)0x1 << 0);

    /* Activo modo Burst */
    LPC_ADC->ADCR |= ((unsigned int)0x1 << 16);


    return positions;
}