

#ifndef DMA_H_
#define DMA_H_

#include "mbed.h"


/************************************DEFINICIONES DE TIPOS********************************************/
/*Estructura de los nodos usados por las Listas del DMA*/
typedef struct
{
    unsigned long int sourceAddr; /*Direccion inicial de la memoria/periferico de partida*/
    unsigned long int destAddr;   /*Direccion inicial de la memoria/periferico de destino*/
    unsigned long int nextNode;   /*Proximo nodo de la lista (una vez que se enviaron todos los datos*/
    unsigned long int dmaControl; /*Registro de configuracion del DMA que puede ser modificado nodo a nodo*/
                                  /* Detalle dmaControl: Pagina 603 del User Manual del LPC1768 */
}dmaLinkedListNode;

/* Tipo de dato booleano */
typedef enum {FALSE, TRUE} bool_t;

/* Tipo de dato usado para saber que buffer debo procesar/escribir */
typedef enum {PING, PONG} pingpong_t;

/*****************************************VARIABLES***************************************************/
/* Se decidio el uso de variables globales en lugar de wrappers para agilizar el codigo lo mas posible. */

/* Esta variable indica si se atendio una interrupcion */
/* Nos indica si se completo la adquisicion de uno de los buffers */
extern bool_t BufferTransferCompleted;

/* Esta variable indica que buffer debo procesar/escribir */
extern pingpong_t BufferToProcess;

/*****************************************FUNCIONES***************************************************/
void initDMAs(dmaLinkedListNode *, dmaLinkedListNode *); /* Inicializacion de los canales DMA */

#endif /* DMA_H_ */
