// --------------------------------------------------------
//  mGTFT.h (c) CopYright 2013-2014 Goji.
// --------------------------------------------------------

#include "mGTFTdev.h"

#define __RGB(r,g,b)    (uint16_t)((r<<11)|(g<<6)|b)
#define WHITE           (__RGB(31, 31, 31))
#define DWHITE          (__RGB(27, 27, 27))
#define RED             (__RGB(31,  0,  0))
#define GREEN           (__RGB( 0, 31,  0))
#define BLUE            (__RGB( 0,  0, 31))
#define BLACK           (__RGB( 0,  0,  0))
#define YELLOW          (__RGB(31, 31,  0))
#define MAGENTA         (__RGB(31,  0, 31))
#define CYAN            (__RGB( 0, 31, 31))
#define GRAY            (__RGB(11, 11, 11))
#define GRAY1           (__RGB(10, 10,  8))
#define GRAY2           (__RGB(16, 16, 14))
#define BLACK1          (__RGB( 0,  0,  1))

#define TFT_STOP()      // { TFT_CS_1; LCDTFT::wr_data(0); }
#define TFT_RUN()       // TFT_CS_0

//#define delay_ms(ms)    wait_ms(ms)
#define TFT_abs(a, b)   ((a > b) ? (a - b) : (b - a))
#define TFT_swap(a, b)  { uint16_t w = a; a = b; b = w; }

void TFT_wr_regs(uint8_t regv);
void TFT_wr_reg(uint16_t regv);
void TFT_wr_index(uint16_t index);
void TFT_wr_data(uint16_t data);
void TFT_wr_index_data(uint16_t index, uint16_t data);

void TFT_init(void);
void TFT_setOrientation(uint16_t am);
void TFT_setWindow(int16_t x1, int16_t y1, int16_t x2, int16_t y2);
void TFT_clearScreen(uint16_t ccolor);
void TFT_setXY(int16_t x1, int16_t y1);
void TFT_setPixel(int16_t x1, int16_t y1, uint16_t ccode);
void TFT_setPixels(int16_t x1, int16_t y1, uint16_t ccode);
void TFT_drawLine(int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint16_t ccolor);
void TFT_drawVerticalLine(int16_t x1, int16_t y1, int16_t y2, uint16_t ccode);
void TFT_drawHorizontalLine(int16_t x1, int16_t y1, int16_t x2, uint16_t ccode);
void TFT_drawRectangle(int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint16_t ccode);
void TFT_fillRectangle(int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint16_t lccode, uint16_t fccode);
void TFT_drawCircle(int16_t x1, int16_t y1, int16_t r, uint16_t lccode, uint16_t fccode);
void TFT_drawFont(int16_t x1, int16_t y1, int16_t width, int16_t line, uint8_t *font, uint16_t fccode, uint16_t bccode);
void TFT_drawICON(int16_t x1, int16_t y1, int16_t width, int16_t line, uint16_t *icon, uint16_t fccode, uint16_t bccode);
uint32_t TFT_getFont(uint8_t *font, int16_t width, int16_t line);
int16_t  TFT_drawText(int16_t x1, int16_t y1, uint8_t *s, uint16_t fccode, uint16_t bccode);
