// --------------------------------------------------------
// mGTFT.c (c) CopYright 2013-2014 Goji.
// --------------------------------------------------------

#include "mbed.h"
#include "mainconf.h"

#include "mGTFT.h"
#include "mGTP.h"
#include "font8x12A.h"

#define  WW   1234
#include "mGTFTini.h"


void TFT_wr_reg(uint16_t regv)
{
    TFT_WR_0;
    TFT_wr_regs(regv >> 8);
    TFT_WR_1;
    TFT_WR_0;
    TFT_wr_regs(regv);
    TFT_WR_1;
}


void TFT_wr_index(uint16_t index)
{
//  TFT_CS_0;
    TFT_RS_0;
    TFT_wr_reg(index);
    TFT_RS_1;
//  TFT_CS_1;
}


void TFT_wr_data(uint16_t data)
{
//  TFT_CS_0;
//  TFT_RS_1;
    TFT_wr_reg(data);
//  TFT_CS_1;
}


void TFT_wr_index_data(uint16_t index, uint16_t data)
{
//  TFT_CS_0;
    TFT_RS_0;
    TFT_wr_reg(index);
    TFT_RS_1;
    TFT_wr_reg(data);
//  TFT_CS_1;
}

void TFT_setOrientation(uint16_t am)
{
    mTFT_SET_ORENTATION(am);
}


void TFT_setWindow(int16_t x1, int16_t y1, int16_t x2, int16_t y2)
{
    TFT_wr_index_data(0x50, y1);
    TFT_wr_index_data(0x51, y2 - 1);
    TFT_wr_index_data(0x52, x1);
    TFT_wr_index_data(0x53, x2 - 1);
    TFT_setOrientation(TFT_HV_HORZ);
    TFT_setXY(x1, y1);
}


void TFT_setXY(int16_t x1, int16_t y1)
{
    TFT_wr_index_data(0x20, y1);
    TFT_wr_index_data(0x21, x1);
    TFT_wr_index(0x22);
}


void TFT_clearScreen(uint16_t ccode)
{
    TFT_setXY(0, 0);
    for (int y = 0; y < TFT_info.yMAX; y++)
        for (int x = 0; x < TFT_info.xMAX; x++)
            TFT_wr_reg(ccode);
}


void TFT_setPixels(int16_t x1, int16_t y1, uint16_t ccode)
{
    if ((x1 >= TFT_info.xMIN) && (x1 < TFT_info.xMAX) &&
        (y1 >= TFT_info.yMIN) && (y1 < TFT_info.yMAX)) {
        TFT_setPixel(x1, y1, ccode);
    }
}


void TFT_setPixel(int16_t x1, int16_t y1, uint16_t ccode)
{
    TFT_setXY(x1, y1);
    TFT_wr_data(ccode);
}

void TFT_drawLine(int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint16_t ccode)
{
    if (x1 == x2) {
        TFT_drawVerticalLine  (x1, y1, y2, ccode);
    } else
    if (y1 == y2) {
        TFT_drawHorizontalLine(x1, y1, x2, ccode);
    } else {
        int16_t dx = TFT_abs(x1, x2);
        int16_t dy = TFT_abs(y1, y2);
        int16_t sx = (x1 < x2) ? 1 : -1;
        int16_t sy = (y1 < y2) ? 1 : -1;
        int16_t er = dx - dy, e2;

        while (1) {
            TFT_setPixels(x1, y1, ccode);
            if ((x1 == x2) && (y1 == y2)) break;
            e2 = er * 2;
            if (e2 > -dx) { er -= dy; x1 += sx; }
            if (e2 <  dx) { er += dx; y1 += sy; }
        }
    }
}


void TFT_drawVerticalLine(int16_t x1, int16_t y1, int16_t y2, uint16_t ccode)
{
    if ((x1 <  TFT_info.xMIN) ||
        (x1 >= TFT_info.xMAX)) return;

    if (y1 > y2) TFT_swap(y1, y2);

    if (y1 <  TFT_info.yMIN) y1 = TFT_info.yMIN;
    if (y1 >= TFT_info.yMAX) y1 = TFT_info.yMAX - 1;
    if (y2 <  TFT_info.yMIN) y2 = TFT_info.yMIN;
    if (y2 >= TFT_info.yMAX) y2 = TFT_info.yMAX - 1;

    mTFT_SET_ORENTATION(TFT_HV_VERT);
    TFT_setXY(x1, y1);
    while (y1++ <= y2)
        TFT_wr_data(ccode);
    mTFT_SET_ORENTATION(TFT_HV_HORZ);
}


void TFT_drawHorizontalLine(int16_t x1, int16_t y1, int16_t x2, uint16_t ccode)
{
    if ((y1 <  TFT_info.yMIN) ||
        (y1 >= TFT_info.yMAX)) return;

    if (x1 > x2) TFT_swap(x1, x2);

    if (x1 <  TFT_info.xMIN) x1 = TFT_info.xMIN;
    if (x1 >= TFT_info.xMAX) x1 = TFT_info.xMAX - 1;
    if (x2 <  TFT_info.xMIN) x2 = TFT_info.xMIN;
    if (x2 >= TFT_info.xMAX) x2 = TFT_info.xMAX - 1;

    TFT_setXY(x1, y1);
    while (x1++ <= x2)
        TFT_wr_data(ccode);
}


void TFT_drawRectangle(int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint16_t ccode)
{
    TFT_drawLine(x1, y1, x1, y2, ccode);
    TFT_drawLine(x1, y1, x2, y1, ccode);
    TFT_drawLine(x1, y2, x2, y2, ccode);
    TFT_drawLine(x2, y1, x2, y2, ccode);
}


void TFT_fillRectangle(int16_t x1, int16_t y1, int16_t x2, int16_t y2, uint16_t lccode, uint16_t fccode)
{
    if (y1 > y2) TFT_swap(y1, y2);

    TFT_drawRectangle(x1++, y1++, x2--, y2--, lccode);
  #if (1)
    while (y1 <= y2)
        TFT_drawHorizontalLine(x1, y1++, x2, fccode);
  #else
    if (x1 <  TFT_info.xMIN) x1 = TFT_info.xMIN;
    if (x1 >= TFT_info.xMAX) x1 = TFT_info.xMAX - 1;
    if (x2 <  TFT_info.xMIN) x2 = TFT_info.xMIN;
    if (x2 >= TFT_info.xMAX) x2 = TFT_info.xMAX - 1;

    while (y1 <= y2) {
        TFT_setXY(x1, y1++);
        for (int wx = x1; wx < x2; wx++)
            wr_data(fccode);
    }
  #endif
}


void TFT_drawCircle(int16_t x1, int16_t y1, int16_t r, uint16_t lccode, uint16_t fccode)
{
    //  http://fussy.web.fc2.com/algo/algo2-1.htm
    int32_t wx = r, wy = 0, lx = r, fx, fy;
    int32_t xy = (r * -2) + 3;

    if (r < 1) return;
    while (wx >= wy) {
        TFT_setPixels(x1 - wx, y1 + wy, lccode);
        TFT_setPixels(x1 + wx, y1 + wy, lccode); 
        TFT_setPixels(x1 - wx, y1 - wy, lccode);
        TFT_setPixels(x1 + wx, y1 - wy, lccode);
        TFT_setPixels(x1 - wy, y1 + wx, lccode);
        TFT_setPixels(x1 + wy, y1 + wx, lccode);
        TFT_setPixels(x1 - wy, y1 - wx, lccode);
        TFT_setPixels(x1 + wy, y1 - wx, lccode);
        if (fccode != BLACK1) {
            fx = wx + wx - 1;
            fy = wy + wy - 1;
            TFT_drawHorizontalLine((x1 - wx) + 1, y1 + wy, (x1 - wx) + 1 + fx, fccode);
            TFT_drawHorizontalLine((x1 - wx) + 1, y1 - wy, (x1 - wx) + 1 + fx, fccode);
            if (lx != wx) {
                lx = wx;
                TFT_drawHorizontalLine((x1 - wy) + 1, y1 + wx, (x1 - wy) + 1 + fy, fccode);
                TFT_drawHorizontalLine((x1 - wy) + 1, y1 - wx, (x1 - wy) + 1 + fy, fccode);
            }
        }
        if (xy >= 0) {
            wx--;
            xy -= wx << 2;
        }
        wy++;
        xy += ((wy << 2) + 2);
    }
}


uint32_t TFT_getFont(uint8_t *font, int16_t width, int16_t line)
{
    if (width <= 8) {
        return (*(font + line) << (32 - 8));
    } else {
        if (width <= 12) {
            uint16_t n = line + (line >> 1);    // n = line * 1.5
            if (line & 1) {
                return ((*(font + n) << (32 - 12)) | (*(font + n + 1) << (32 - 4)));
            } else {
                return ((*(font + n) << (32 - 16)) | (*(font + n + 1) << (32 - 8)));
            }
        } else {
            return (*(uint32_t *)((uint8_t *)font + ((width / 8) * line)));
        }
    }
}


void TFT_drawFont(int16_t x1, int16_t y1, int16_t width, int16_t line, uint8_t *font, uint16_t fccode, uint16_t bccode)
{
    int j;
    uint32_t k;

    if (((x1 + width) < TFT_info.xMIN) || (x1 >= TFT_info.xMAX) ||
        ((y1 + line ) < TFT_info.yMIN) || (y1 >= TFT_info.yMAX)) return;

    for (int i = 0; i < line; i++) {
        uint32_t p = TFT_getFont(font, width, i);
        for (j = 0, k = 0x80000000; j < width; j++, k >>= 1) {
            if (p & k)
                TFT_setPixels(x1 + j, y1 + i, fccode);
            else
                if (bccode != BLACK1)
                    TFT_setPixels(x1 + j, y1 + i, bccode);
        }
    }
}


int16_t TFT_drawText(int16_t x1, int16_t y1, uint8_t *s, uint16_t fccode, uint16_t bccode)
{
    uint8_t cc;

    while ((cc = *s++) != '\0') {
        if (cc > 0x7F) cc = ' ';
        TFT_drawFont(x1, y1, 8, 12, (uint8_t*)&font8x12A[cc][0], fccode, bccode);
        x1 += 8;
    }
    return x1;
}
