// --------------------------------------------------------
//  mGTPlib.c (c) Copyright 2013-2014 Goji.
// --------------------------------------------------------

#include "mbed.h"
#include "mainconf.h"

#include "mGTP.h"

extern  TFT_INFO TFT_info;

#define TPC_ABS(a,b)    ((a>b)?(a-b):(b-a))

int16_t TPC_getXYO(int16_t *dx, int16_t *dy)
{
    int16_t wx1, wx2, wy1, wy2;

    if ((wx1 = get_pX()) < TFT_info.TPC_xNon) return(0);
    if ((wy1 = get_pY()) < TFT_info.TPC_yNon) return(0);
    wait_us(300);
    if ((wx2 = get_pX()) < TFT_info.TPC_xNon) return(0);
    if ((wy2 = get_pY()) < TFT_info.TPC_yNon) return(0);
    if ((TPC_ABS(wx1, wx2) > 20) || (TPC_ABS(wy1, wy2) > 20)) return(1);

    *dx = (wx1 + wx2) / 2;
    *dy = (wy1 + wy2) / 2;

    return(2);
}

int16_t TPC_getXY(int16_t *dx, int16_t *dy)
{
    int16_t rc;

    if ((rc = TPC_getXYO(dx, dy)) != 2) return(rc);

    *dx = (*dx > TFT_info.TPC_xMin) ? (*dx - TFT_info.TPC_xMin) : 0;
    *dy = (*dy > TFT_info.TPC_yMin) ? (*dy - TFT_info.TPC_yMin) : 0;
    if (*dx > TFT_info.TPC_xMax) *dx = TFT_info.TPC_xMax;
    if (*dy > TFT_info.TPC_yMax) *dy = TFT_info.TPC_yMax;

    *dx = ((((*dx * 1000) / TFT_info.TPC_xMax) * (TFT_info.xMAX - 1)) / 1000);
    *dy = ((((*dy * 1000) / TFT_info.TPC_yMax) * (TFT_info.yMAX - 1)) / 1000);

    return(2);
}
