// --------------------------------------------------------
//  aitend26.c (c) Copyright 2013-2014 Goji.
// --------------------------------------------------------

#include "mbed.h"
#include "mainconf.h"

#include "mGTP.h"

#if defined(aitendo26)
//====================
void TPC_Init(void)
{
    // ADC settings
    LPC_SC->PCONP        |=  (BIT1(12));    // PCADC: A/D converter (ADC) power/clock enable
    LPC_SC->PCLKSEL0     &= ~(BIT3(24));    // PCLK_ADC: PCLK_peripheral 00 = CCLK/4
    LPC_ADC->ADCR         =  ( 0 <<  0)     // SEL: Channels select 0 = No selected 
                           | (50 <<  8)     // CLKDIV: PCLK max ~= 25MHz, /50 = 500KHz
                           | ( 0 << 16)     // BURST: 0 = software control 
                           | ( 0 << 17)     // CLKS: not applicable
                           | ( 1 << 21)     // PDN: 1 = operational
                           | ( 0 << 24)     // START: 0 = no start
                           | ( 0 << 27);    // EDGE: not applicable
}


/*
    DigitalInOut U_D6(p22);     // X+ (D6)  p22 = P2.4
    DigitalInOut U_D7(p21);     // Y- (D7)  p21 = P2.5
    AnalogIn     U_A1(p16);     // Y+ (A1)  p16 = P0.24 TFT_WR
    AnalogIn     U_A2(p17);     // X- (A2)  p17 = P0.25 TFT_RS
 */

int16_t get_pX(void)
{
    int16_t adcv;

    TFT_STOP();

    // Y+ P0.24 Output High
//  LPC_PINCON->PINSEL1  &= ~(BIT3(16));    // Set pin Function P0.24 for GPIO(00)
//  LPC_GPIO0->FIODIR    |=  (BIT1(24));    // Set pin Direction P0.24 for Output(1)
    LPC_GPIO0->FIOSET     =  (BIT1(24));    // Set pin High(1)

    // Y- P2.5 Output Low
//  LPC_PINCON->PINSEL4  &= ~(BIT3(10));    // Set pin Function P2.5 for GPIO(00)
//  LPC_GPIO2->FIODIR    |=  (BIT1( 5));    // Set pin Direction P2.5 for Output(1)
    LPC_GPIO2->FIOCLR     =  (BIT1( 5));    // Set pin Low(0)

    // X+ P2.4 Input mode
//  LPC_PINCON->PINSEL4  &= ~(BIT3( 8));    // Set pin Function P2.4 for GPIO(00)
    LPC_GPIO2->FIODIR    &= ~(BIT1( 4));    // Set pin Direction P2.4 for Input(0)
//  LPC_PINCON->PINMODE4 &= ~(BIT3( 8));    // P2.4 pull-down(11)
    LPC_PINCON->PINMODE4 |=  (BIT3( 8));    // ..

    // X- P0.25 ADC mode
    LPC_PINCON->PINSEL1  &= ~(BIT3(18));    // Set pin function P0.25 for AD0.2(01)
    LPC_PINCON->PINSEL1  |=  (BIT1(18));    // ..
//  LPC_PINCON->PINMODE1 &= ~(BIT3(18));    // P0.25 pull-down(11)
    LPC_PINCON->PINMODE1 |=  (BIT3(18));    // ..

    LPC_ADC->ADCR        &= ~(0xFF);        // ADC Channel Clear
    LPC_ADC->ADCR        |=  (BIT1( 2));    // ADC Channel AD0.2[P0.25]
    for (int w = 0; w < 100; ) w++;         // Wait for stable
    LPC_ADC->ADCR        |=  (BIT1(24));    // ADC Start
    while (!(LPC_ADC->ADGDR & BIT1(31)));   // Wait DONE bit
    LPC_ADC->ADCR        &= ~(BIT7(24));    // ADC Stop

    adcv = (LPC_ADC->ADGDR >> 4) & 0x0FFF;

    // X+ P2.4 Output Low
//  LPC_PINCON->PINSEL4  &= ~(BIT3( 8));    // Set pin Function P2.4 for GPIO(00)
    LPC_GPIO2->FIODIR    |=  (BIT1( 4));    // Set pin Direction P2.4 for Output(1)
//  LPC_GPIO2->FIOSET     =  (BIT1( 4));    // Set pin Low(0)

    // X- P0.25 Output Low
    LPC_PINCON->PINSEL1  &= ~(BIT3(18));    // Set pin function P0.25 for GPIO(00)
    LPC_GPIO0->FIODIR    |=  (BIT1(25));    // Set pin Direction P0.25 for Output(1)
//  LPC_GPIO0->FIOCLR     =  (BIT1(25));    // Set pin Low(0)

    // Y+ P0.24 Output Low
//  LPC_PINCON->PINSEL1  &= ~(BIT3(16));    // Set pin Function P0.24 for GPIO(00)
//  LPC_GPIO0->FIODIR    |=  (BIT1(24));    // Set pin Direction P0.24 for Output(1)
//  LPC_GPIO0->FIOCLR     =  (BIT1(24));    // Set pin Low(0)

    // Y- P2.5 Output Low
//  LPC_PINCON->PINSEL4  &= ~(BIT3(10));    // Set pin Function P2.5 for GPIO(00)
//  LPC_GPIO2->FIODIR    |=  (BIT1( 5));    // Set pin Direction P2.5 for Output(1)
//  LPC_GPIO2->FIOCLR     =  (BIT1( 5));    // Set pin Low(0)

    TFT_RUN();
    return(adcv);
}

int16_t get_pY(void)
{
    uint16_t adcv;

    TFT_STOP();

    // X+ P2.4 Output High
//  LPC_PINCON->PINSEL4  &= ~(BIT3( 8));    // Set pin Function P2.4 for GPIO(00)
//  LPC_GPIO2->FIODIR    |=  (BIT1( 4));    // Set pin Direction P2.4 for Output(1)
    LPC_GPIO2->FIOSET     =  (BIT1( 4));    // Set pin zHigh(1)

    // X- P0.25 Output Low
//  LPC_PINCON->PINSEL1  &= ~(BIT3(18));    // Set pin Function P0.25 for GPIO(00)
//  LPC_GPIO0->FIODIR    |=  (BIT1(25));    // Set pin Direction P0.25 for Output(1)
    LPC_GPIO0->FIOCLR     =  (BIT1(25));    // Set pin Low(0)

    // Y- P2.5 Input
//  LPC_PINCON->PINSEL4  &= ~(BIT3(10));    // Set pin Function P2.5 for GPIO(00)
    LPC_GPIO2->FIODIR    &= ~(BIT1( 5));    // Set pin Direction P2.5 for input(0)
//  LPC_PINCON->PINMODE4 &= ~(BIT3(10));    // P2.5 pull-down(11)
    LPC_PINCON->PINMODE4 |=  (BIT3(10));    // ..

    // Y+ P0.24 ADC mode
    LPC_PINCON->PINSEL1  &= ~(BIT3(16));    // Set pin function P0.24 for AD0.1(01)
    LPC_PINCON->PINSEL1  |=  (BIT1(16));    // ..
//  LPC_PINCON->PINMODE1 &= ~(BIT3(16));    // P0.24 pull-down(11)
    LPC_PINCON->PINMODE1 |=  (BIT3(16));    // ..

    LPC_ADC->ADCR        &= ~(0xFF);        // ADC Channel Clear
    LPC_ADC->ADCR        |=  (BIT1( 1));    // ADC Channel AD0.1[P0.24]
    for (int w = 0; w < 100; ) w++;         // Wait for stable
    LPC_ADC->ADCR        |=  (BIT1(24));    // ADC Start
    while (!(LPC_ADC->ADGDR & BIT1(31)));   // Wait DONE bit
    LPC_ADC->ADCR        &= ~(BIT7(24));    // ADC Stop

  #if defined(MCUFRIEND)
    // mcufriend
    adcv = 0x1000 - ((LPC_ADC->ADGDR >> 4) & 0x0FFF);
  #else
    adcv = (LPC_ADC->ADGDR >> 4) & 0x0FFF;
  #endif

    // X+ P2.4 Output Low
//  LPC_PINCON->PINSEL4  &= ~(BIT3( 8));    // Set pin Function P2.4 for GPIO(00)
//  LPC_GPIO2->FIODIR    |=  (BIT1( 4));    // Set pin Direction P2.4 for Output(1)
//  LPC_GPIO2->FIOSET     =  (BIT1( 4));    // Set pin Low(0)

    // X- P0.25 Output Low
//  LPC_PINCON->PINSEL1  &= ~(BIT3(18));    // Set pin function P0.25 for GPIO(00)
//  LPC_GPIO0->FIODIR    |=  (BIT1(25));    // Set pin Direction P0.25 for Output(1)
//  LPC_GPIO0->FIOCLR     =  (BIT1(25));    // Set pin Low(0)

    // Y+ P0.24 Output Low
    LPC_PINCON->PINSEL1  &= ~(BIT3(16));    // Set pin Function P0.24 for GPIO(00)
    LPC_GPIO0->FIODIR    |=  (BIT1(24));    // Set pin Direction P0.24 for Output(1)
//  LPC_GPIO0->FIOCLR     =  (BIT1(24));    // Set pin Low(0)

    // Y- P2.5 Output Low
//  LPC_PINCON->PINSEL4  &= ~(BIT3(10));    // Set pin Function P2.5 for GPIO(00)
    LPC_GPIO2->FIODIR    |=  (BIT1( 5));    // Set pin Direction P2.5 for Output(1)
//  LPC_GPIO2->FIOCLR     =  (BIT1( 5));    // Set pin Low(0)

    TFT_RUN();
    return((int16_t)adcv);
}

//====================
#endif
